/*
 * Decompiled with CFR 0.152.
 */
package cn.messageplus.core;

import cn.messageplus.core.EnableMessagePlusCore;
import cn.messageplus.core.MessagePlusAgreement;
import cn.messageplus.core.annotation.MessagePlusHandler;
import cn.messageplus.core.annotation.MessagePlusMapping;
import cn.messageplus.core.annotation.MessagePlusRequest;
import cn.messageplus.core.annotation.MessagePlusResponse;
import cn.messageplus.core.codec.BinaryWebSocketCodec;
import cn.messageplus.core.codec.MessageCodec;
import cn.messageplus.core.codec.TextWebSocketCodec;
import cn.messageplus.core.entity.ChatRoom;
import cn.messageplus.core.entity.Group;
import cn.messageplus.core.handler.EventHandler;
import cn.messageplus.core.handler.HeartbeatRequestHandler;
import cn.messageplus.core.handler.MessageHandler;
import cn.messageplus.core.handler.PathRequestHandler;
import cn.messageplus.core.implement.SelectChatRoomInterface;
import cn.messageplus.core.implement.SelectGroupInterface;
import cn.messageplus.core.manage.ChatRoomManage;
import cn.messageplus.core.manage.GroupManage;
import cn.messageplus.core.manage.SessionManage;
import cn.messageplus.core.message.Message;
import cn.messageplus.core.message.MessageFactory;
import cn.messageplus.core.properties.MPCProperties;
import cn.messageplus.core.utils.exterior.SpringUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class StartCore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StartCore.class);
    private static final ServerBootstrap serverBootstrap = new ServerBootstrap();
    private static final NioEventLoopGroup boss = new NioEventLoopGroup();
    private static final NioEventLoopGroup worker = new NioEventLoopGroup();
    private static final MessageCodec MESSAGE_CODEC = new MessageCodec();
    private static final BinaryWebSocketCodec BINARY_WEB_SOCKET_CODEC = new BinaryWebSocketCodec();
    private static final TextWebSocketCodec TEXT_WEB_SOCKET_CODEC = new TextWebSocketCodec();
    private static MessagePlusAgreement protocolType = MessagePlusAgreement.MPCA;
    private static List<SimpleChannelInboundHandler<?>> customRequestHandlerList;
    public static final Map<String, Class<?>> mapByPathAndClass;
    public static final Map<String, Method> mapByPathAndMethod;

    private static void configureProtocolType() {
        List<Object> beansWithAnnotation = SpringUtils.getBeansWithAnnotation(EnableMessagePlusCore.class);
        if (beansWithAnnotation.isEmpty()) {
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5230\u6dfb\u52a0@EnableMessagePlusCore\u6ce8\u89e3\u7684\u7c7b");
        }
        Object application = beansWithAnnotation.get(0);
        protocolType = application.getClass().getAnnotation(EnableMessagePlusCore.class).value();
    }

    private static void configureAnnotationRelated() {
        List<Message> requestList = SpringUtils.getBeansWithAnnotation(MessagePlusRequest.class).stream().map(o -> (Message)o).collect(Collectors.toList());
        MessageFactory.addMessageTypes(requestList);
        List<Message> responseList = SpringUtils.getBeansWithAnnotation(MessagePlusResponse.class).stream().map(o -> (Message)o).collect(Collectors.toList());
        MessageFactory.addMessageTypes(responseList);
        customRequestHandlerList = SpringUtils.getBeansWithAnnotation(MessagePlusHandler.class).stream().map(o -> (SimpleChannelInboundHandler)o).collect(Collectors.toList());
        List<Object> beansWithMessagePlusMapping = SpringUtils.getBeansWithAnnotation(MessagePlusMapping.class);
        for (Object bean : beansWithMessagePlusMapping) {
            Method[] methods;
            String basePath = bean.getClass().getAnnotation(MessagePlusMapping.class).value();
            for (Method method : methods = bean.getClass().getMethods()) {
                MessagePlusMapping annotation = method.getAnnotation(MessagePlusMapping.class);
                if (annotation == null) continue;
                String methodPath = annotation.value();
                String fullPath = basePath + methodPath;
                mapByPathAndClass.put(fullPath, bean.getClass());
                mapByPathAndMethod.put(fullPath, method);
            }
        }
    }

    private static void configureByMPCA(SocketChannel ch) {
        ch.pipeline().addLast(new ChannelHandler[]{MESSAGE_CODEC});
    }

    private static void configureByWEBSOCKET(SocketChannel ch) {
        ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()});
        ch.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        ch.pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/")});
        ch.pipeline().addLast(new ChannelHandler[]{BINARY_WEB_SOCKET_CODEC});
        ch.pipeline().addLast(new ChannelHandler[]{TEXT_WEB_SOCKET_CODEC});
    }

    static {
        mapByPathAndClass = new ConcurrentHashMap();
        mapByPathAndMethod = new ConcurrentHashMap<String, Method>();
        new Thread(() -> {
            SelectChatRoomInterface sci;
            StartCore.configureProtocolType();
            StartCore.configureAnnotationRelated();
            SelectGroupInterface sgi = SpringUtils.getBean(SelectGroupInterface.class);
            if (sgi != null) {
                List<Group> select = sgi.select();
                GroupManage.settingGroups(select);
            }
            if ((sci = SpringUtils.getBean(SelectChatRoomInterface.class)) != null) {
                List<ChatRoom> select = sci.select();
                ChatRoomManage.settingChatRoom(select);
            }
            final EventHandler EVENT_HANDLER = new EventHandler();
            final MessageHandler MESSAGE_HANDLER = new MessageHandler();
            final HeartbeatRequestHandler HEARTBEAT_REQUEST_HANDLER = new HeartbeatRequestHandler();
            final PathRequestHandler PATH_REQUEST_HANDLER = new PathRequestHandler();
            try {
                serverBootstrap.channel(NioServerSocketChannel.class);
                serverBootstrap.group((EventLoopGroup)boss, (EventLoopGroup)worker);
                serverBootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(SocketChannel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(30, 0, 0)});
                        ch.pipeline().addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

                            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                                IdleStateEvent event = (IdleStateEvent)evt;
                                if (event.state() == IdleState.READER_IDLE) {
                                    log.debug("{} does not send a heartbeat request within 30s, forced disconnection", (Object)SessionManage.getUid(ctx.channel()));
                                    ctx.channel().close();
                                }
                            }
                        }});
                        switch (protocolType) {
                            case MPCA: {
                                StartCore.configureByMPCA(ch);
                                break;
                            }
                            case WEB_SOCKET: {
                                StartCore.configureByWEBSOCKET(ch);
                            }
                        }
                        ch.pipeline().addLast(new ChannelHandler[]{MESSAGE_HANDLER});
                        ch.pipeline().addLast(new ChannelHandler[]{HEARTBEAT_REQUEST_HANDLER});
                        ch.pipeline().addLast(new ChannelHandler[]{PATH_REQUEST_HANDLER});
                        for (SimpleChannelInboundHandler handler : customRequestHandlerList) {
                            ch.pipeline().addLast(new ChannelHandler[]{handler});
                        }
                        ch.pipeline().addLast(new ChannelHandler[]{EVENT_HANDLER});
                    }

                    protected Object clone() throws CloneNotSupportedException {
                        log.warn("\u5173\u95ed\u94fe\u63a5");
                        return super.clone();
                    }
                });
                ChannelFuture channelFuture = serverBootstrap.bind((int)MPCProperties.getPort()).sync();
                log.info("\u542f\u52a8\u5b8c\u6210");
                log.info("port: {}", (Object)MPCProperties.port);
                channelFuture.channel().closeFuture().sync();
                System.out.println("\u5173\u95ed");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                boss.shutdownGracefully();
                worker.shutdownGracefully();
            }
        }).start();
    }
}

