/*
 * Decompiled with CFR 0.152.
 */
package com.sx.log.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileAppender;
import cn.hutool.json.JSONUtil;
import com.sx.log.base.AccessLog;
import com.sx.log.config.LogConfig;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import java.io.File;

public class LogUtils {
    private static final String LOG_NAME = "/access-log.log";

    public static void login(String userId, UserRoleEnum userRoleEnum, String areaCode) {
        LogUtils.saveLog(new AccessLog(userId, userRoleEnum, areaCode, ActionTypeEnum.LOGIN_TYPE, ""));
    }

    public static void logout(String userId, UserRoleEnum userRoleEnum, String areaCode) {
        LogUtils.saveLog(new AccessLog(userId, userRoleEnum, areaCode, ActionTypeEnum.LOGOUT_TYPE, ""));
    }

    public static void workStart(String userId, UserRoleEnum userRoleEnum, String areaCode, String actionId) {
        LogUtils.saveLog(new AccessLog(userId, userRoleEnum, areaCode, ActionTypeEnum.WORK_START_TYPE, actionId));
    }

    public static void workEnd(String userId, UserRoleEnum userRoleEnum, String areaCode, String actionId) {
        LogUtils.saveLog(new AccessLog(userId, userRoleEnum, areaCode, ActionTypeEnum.WORK_END_TYPE, actionId));
    }

    public static void bizLog(String bizType, String bizValue) {
        LogUtils.saveLog(new AccessLog(ActionTypeEnum.BIZ_LOG_TYPE, bizType, bizValue));
    }

    private static void saveLog(AccessLog accessLog) {
        File logFile = FileUtil.file((String)(LogConfig.logPath + LOG_NAME));
        if (!logFile.exists()) {
            logFile = FileUtil.touch((File)logFile);
        }
        FileAppender logFileAppender = new FileAppender(logFile, 16, true);
        logFileAppender.append(JSONUtil.toJsonStr((Object)accessLog));
        logFileAppender.flush();
    }
}

