/*
 * Decompiled with CFR 0.152.
 */
package io.github.talelin.autoconfigure.validator.impl;

import io.github.talelin.autoconfigure.validator.DateTimeFormat;
import java.text.SimpleDateFormat;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeFormatValidator
implements ConstraintValidator<DateTimeFormat, String> {
    private static final Logger log = LoggerFactory.getLogger(DateTimeFormatValidator.class);
    private DateTimeFormat dateTimeFormat;

    public void initialize(DateTimeFormat dateTime) {
        this.dateTimeFormat = dateTime;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        String format = this.dateTimeFormat.pattern();
        if (value.length() != format.length()) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        try {
            simpleDateFormat.parse(value);
            return true;
        }
        catch (Exception e) {
            log.warn("DateTimeFormat \u6821\u9a8c\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }
}

