/*
 * Decompiled with CFR 0.152.
 */
package io.github.talelin.autoconfigure.interceptor;

import io.github.talelin.autoconfigure.bean.MetaInfo;
import io.github.talelin.autoconfigure.bean.PermissionMetaCollector;
import io.github.talelin.autoconfigure.interfaces.AuthorizeVerifyResolver;
import io.github.talelin.core.enumeration.UserLevel;
import io.github.talelin.core.util.AnnotationUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AuthorizeInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private AuthorizeVerifyResolver authorizeVerifyResolver;
    @Autowired
    private PermissionMetaCollector permissionMetaCollector;
    private String[] excludeMethods = new String[]{"OPTIONS"};

    public AuthorizeInterceptor() {
    }

    public AuthorizeInterceptor(String[] excludeMethods) {
        this.excludeMethods = excludeMethods;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (this.checkInExclude(request.getMethod())) {
            return true;
        }
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            String methodName = method.getName();
            String className = method.getDeclaringClass().getName();
            String identity = className + "#" + methodName;
            MetaInfo meta = this.permissionMetaCollector.findMeta(identity);
            if (meta == null) {
                return this.handleNoMeta(request, response, method);
            }
            return this.handleMeta(request, response, method, meta);
        }
        return this.authorizeVerifyResolver.handleNotHandlerMethod(request, response, handler);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        this.authorizeVerifyResolver.handlePostHandle(request, response, handler, modelAndView);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        this.authorizeVerifyResolver.handleAfterCompletion(request, response, handler, ex);
    }

    private boolean handleNoMeta(HttpServletRequest request, HttpServletResponse response, Method method) {
        Annotation[] annotations = method.getAnnotations();
        UserLevel level = AnnotationUtil.findRequired((Annotation[])annotations);
        switch (level) {
            case LOGIN: 
            case GROUP: {
                return this.authorizeVerifyResolver.handleLogin(request, response, null);
            }
            case ADMIN: {
                return this.authorizeVerifyResolver.handleAdmin(request, response, null);
            }
            case REFRESH: {
                return this.authorizeVerifyResolver.handleRefresh(request, response, null);
            }
        }
        return true;
    }

    private boolean handleMeta(HttpServletRequest request, HttpServletResponse response, Method method, MetaInfo meta) {
        UserLevel level = meta.getUserLevel();
        switch (level) {
            case LOGIN: {
                return this.authorizeVerifyResolver.handleLogin(request, response, meta);
            }
            case GROUP: {
                return this.authorizeVerifyResolver.handleGroup(request, response, meta);
            }
            case ADMIN: {
                return this.authorizeVerifyResolver.handleAdmin(request, response, meta);
            }
            case REFRESH: {
                return this.authorizeVerifyResolver.handleRefresh(request, response, meta);
            }
        }
        return true;
    }

    private boolean checkInExclude(String method) {
        for (String excludeMethod : this.excludeMethods) {
            if (!method.equals(excludeMethod)) continue;
            return true;
        }
        return false;
    }
}

