/*
 * Decompiled with CFR 0.152.
 */
package io.github.talelin.autoconfigure.bean;

import io.github.talelin.autoconfigure.bean.MetaInfo;
import io.github.talelin.core.annotation.AdminMeta;
import io.github.talelin.core.annotation.GroupMeta;
import io.github.talelin.core.annotation.LoginMeta;
import io.github.talelin.core.annotation.PermissionMeta;
import io.github.talelin.core.annotation.PermissionModule;
import io.github.talelin.core.enumeration.UserLevel;
import io.github.talelin.core.util.AnnotationUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class PermissionMetaCollector
implements BeanPostProcessor {
    private Map<String, MetaInfo> metaMap = new ConcurrentHashMap<String, MetaInfo>();
    private Map<String, Map<String, Set<String>>> structuralMeta = new ConcurrentHashMap<String, Map<String, Set<String>>>();

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Method[] methods;
        Controller controllerAnnotation = (Controller)AnnotationUtils.findAnnotation(bean.getClass(), Controller.class);
        if (controllerAnnotation == null) {
            return bean;
        }
        for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(bean.getClass())) {
            AdminMeta adminMeta = (AdminMeta)AnnotationUtils.findAnnotation((Method)method, AdminMeta.class);
            if (adminMeta != null && adminMeta.mount()) {
                String permission = StringUtils.isEmpty((Object)adminMeta.value()) ? adminMeta.permission() : adminMeta.value();
                this.putOneMetaInfo(method, permission, adminMeta.module(), UserLevel.ADMIN);
                continue;
            }
            GroupMeta groupMeta = (GroupMeta)AnnotationUtils.findAnnotation((Method)method, GroupMeta.class);
            if (groupMeta != null && groupMeta.mount()) {
                String permission = StringUtils.isEmpty((Object)groupMeta.value()) ? groupMeta.permission() : groupMeta.value();
                this.putOneMetaInfo(method, permission, groupMeta.module(), UserLevel.GROUP);
                continue;
            }
            LoginMeta loginMeta = (LoginMeta)AnnotationUtils.findAnnotation((Method)method, LoginMeta.class);
            if (loginMeta != null && loginMeta.mount()) {
                String permission = StringUtils.isEmpty((Object)loginMeta.value()) ? loginMeta.permission() : loginMeta.value();
                this.putOneMetaInfo(method, permission, loginMeta.module(), UserLevel.LOGIN);
                continue;
            }
            PermissionMeta permissionMeta = (PermissionMeta)AnnotationUtils.findAnnotation((Method)method, PermissionMeta.class);
            if (permissionMeta == null || !permissionMeta.mount()) continue;
            String permission = StringUtils.isEmpty((Object)permissionMeta.value()) ? permissionMeta.permission() : permissionMeta.value();
            UserLevel level = AnnotationUtil.findRequired((Annotation[])method.getAnnotations());
            this.putOneMetaInfo(method, permission, permissionMeta.module(), level);
        }
        return bean;
    }

    private void putOneMetaInfo(Method method, String permission, String module, UserLevel userLevel) {
        PermissionModule permissionModule;
        if (StringUtils.isEmpty((Object)module) && (permissionModule = (PermissionModule)AnnotationUtils.findAnnotation(method.getDeclaringClass(), PermissionModule.class)) != null) {
            module = StringUtils.isEmpty((Object)permissionModule.value()) ? method.getDeclaringClass().getName() : permissionModule.value();
        }
        String methodName = method.getName();
        String className = method.getDeclaringClass().getName();
        String identity = className + "#" + methodName;
        MetaInfo metaInfo = new MetaInfo(permission, module, identity, userLevel);
        this.metaMap.put(identity, metaInfo);
        this.putMetaIntoStructuralMeta(identity, metaInfo);
    }

    private void putMetaIntoStructuralMeta(String identity, MetaInfo meta) {
        String module = meta.getModule();
        String permission = meta.getPermission();
        if (this.structuralMeta.containsKey(module)) {
            Map<String, Set<String>> moduleMap = this.structuralMeta.get(module);
            this.putIntoModuleMap(moduleMap, identity, permission);
        } else {
            HashMap<String, Set<String>> moduleMap = new HashMap<String, Set<String>>();
            this.putIntoModuleMap(moduleMap, identity, permission);
            this.structuralMeta.put(module, moduleMap);
        }
    }

    private void putIntoModuleMap(Map<String, Set<String>> moduleMap, String identity, String auth) {
        if (moduleMap.containsKey(auth)) {
            moduleMap.get(auth).add(identity);
        } else {
            HashSet<String> eps = new HashSet<String>();
            eps.add(identity);
            moduleMap.put(auth, eps);
        }
    }

    public Map<String, MetaInfo> getMetaMap() {
        return this.metaMap;
    }

    public MetaInfo findMeta(String key) {
        return this.metaMap.get(key);
    }

    public MetaInfo findMetaByPermission(String permission) {
        MetaInfo[] objects;
        Collection<MetaInfo> values = this.metaMap.values();
        for (MetaInfo object : objects = values.toArray(new MetaInfo[0])) {
            if (!object.getPermission().equals(permission)) continue;
            return object;
        }
        return null;
    }

    public void setMetaMap(Map<String, MetaInfo> metaMap) {
        this.metaMap = metaMap;
    }

    public Map<String, Map<String, Set<String>>> getStructuralMeta() {
        return this.structuralMeta;
    }

    public void setStructrualMeta(Map<String, Map<String, Set<String>>> structuralMeta) {
        this.structuralMeta = structuralMeta;
    }
}

