/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.trace;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.plugin.trace.spi.NacosTraceSubscriber;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosTracePluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosTracePluginManager.class);
    private static final NacosTracePluginManager INSTANCE = new NacosTracePluginManager();
    private final Map<String, NacosTraceSubscriber> traceSubscribers = new ConcurrentHashMap<String, NacosTraceSubscriber>();

    private NacosTracePluginManager() {
        Collection plugins = NacosServiceLoader.load(NacosTraceSubscriber.class);
        for (NacosTraceSubscriber each : plugins) {
            this.traceSubscribers.put(each.getName(), each);
            LOGGER.info("[TracePluginManager] Load NacosTraceSubscriber({}) name({}) successfully.", each.getClass(), (Object)each.getName());
        }
    }

    public static NacosTracePluginManager getInstance() {
        return INSTANCE;
    }

    public Collection<NacosTraceSubscriber> getAllTraceSubscribers() {
        return new HashSet<NacosTraceSubscriber>(this.traceSubscribers.values());
    }
}

