/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.remote.rpc.handler;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.remote.request.NamingFuzzyWatchRequest;
import com.alibaba.nacos.api.naming.remote.response.NamingFuzzyWatchResponse;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.naming.core.v2.event.client.ClientOperationEvent;
import com.alibaba.nacos.naming.core.v2.index.NamingFuzzyWatchContextService;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import org.springframework.stereotype.Component;

@Component(value="namingFuzzyWatchRequestHandler")
public class NamingFuzzyWatchRequestHandler
extends RequestHandler<NamingFuzzyWatchRequest, NamingFuzzyWatchResponse> {
    private NamingFuzzyWatchContextService namingFuzzyWatchContextService;

    public NamingFuzzyWatchRequestHandler(NamingFuzzyWatchContextService namingFuzzyWatchContextService) {
        this.namingFuzzyWatchContextService = namingFuzzyWatchContextService;
        NotifyCenter.registerToPublisher(ClientOperationEvent.ClientFuzzyWatchEvent.class, (int)1000);
    }

    @Secured(action=ActionTypes.READ)
    public NamingFuzzyWatchResponse handle(NamingFuzzyWatchRequest request, RequestMeta meta) throws NacosException {
        String groupKeyPattern = request.getGroupKeyPattern();
        switch (request.getWatchType()) {
            case "WATCH": {
                try {
                    this.namingFuzzyWatchContextService.syncFuzzyWatcherContext(groupKeyPattern, meta.getConnectionId());
                    NotifyCenter.publishEvent((Event)new ClientOperationEvent.ClientFuzzyWatchEvent(groupKeyPattern, meta.getConnectionId(), request.getReceivedGroupKeys(), request.isInitializing()));
                }
                catch (NacosException nacosException) {
                    NamingFuzzyWatchResponse namingFuzzyWatchResponse = new NamingFuzzyWatchResponse();
                    namingFuzzyWatchResponse.setErrorInfo(nacosException.getErrCode(), nacosException.getErrMsg());
                    return namingFuzzyWatchResponse;
                }
                boolean reachToUpLimit = this.namingFuzzyWatchContextService.reachToUpLimit(groupKeyPattern);
                if (reachToUpLimit) {
                    NamingFuzzyWatchResponse namingFuzzyWatchResponse = new NamingFuzzyWatchResponse();
                    namingFuzzyWatchResponse.setErrorInfo(ErrorCode.FUZZY_WATCH_PATTERN_MATCH_COUNT_OVER_LIMIT.getCode().intValue(), ErrorCode.FUZZY_WATCH_PATTERN_MATCH_COUNT_OVER_LIMIT.getMsg());
                    return namingFuzzyWatchResponse;
                }
                return NamingFuzzyWatchResponse.buildSuccessResponse();
            }
            case "CANCEL_WATCH": {
                this.namingFuzzyWatchContextService.removeFuzzyWatchContext(groupKeyPattern, meta.getConnectionId());
                return NamingFuzzyWatchResponse.buildSuccessResponse();
            }
        }
        throw new NacosException(400, String.format("Unsupported request type %s", request.getWatchType()));
    }
}

