/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.naming.core.InstanceOperator;
import com.alibaba.nacos.naming.core.InstancePatchObject;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.ClientAttributes;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManagerDelegate;
import com.alibaba.nacos.naming.core.v2.event.metadata.InfoChangeEvent;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.metadata.InstanceMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataOperateService;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.service.ClientOperationService;
import com.alibaba.nacos.naming.core.v2.service.ClientOperationServiceProxy;
import com.alibaba.nacos.naming.healthcheck.HealthCheckReactor;
import com.alibaba.nacos.naming.healthcheck.RsInfo;
import com.alibaba.nacos.naming.healthcheck.heartbeat.ClientBeatProcessorV2;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.pojo.InstanceOperationInfo;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.pojo.instance.BeatInfoInstanceBuilder;
import com.alibaba.nacos.naming.push.UdpPushService;
import com.alibaba.nacos.naming.utils.ServiceUtil;
import com.alibaba.nacos.naming.web.ClientAttributesFilter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@org.springframework.stereotype.Service
public class InstanceOperatorClientImpl
implements InstanceOperator {
    private final ClientManager clientManager;
    private final ClientOperationService clientOperationService;
    private final ServiceStorage serviceStorage;
    private final NamingMetadataOperateService metadataOperateService;
    private final NamingMetadataManager metadataManager;
    private final SwitchDomain switchDomain;
    private final UdpPushService pushService;

    public InstanceOperatorClientImpl(ClientManagerDelegate clientManager, ClientOperationServiceProxy clientOperationService, ServiceStorage serviceStorage, NamingMetadataOperateService metadataOperateService, NamingMetadataManager metadataManager, SwitchDomain switchDomain, UdpPushService pushService) {
        this.clientManager = clientManager;
        this.clientOperationService = clientOperationService;
        this.serviceStorage = serviceStorage;
        this.metadataOperateService = metadataOperateService;
        this.metadataManager = metadataManager;
        this.switchDomain = switchDomain;
        this.pushService = pushService;
    }

    @Override
    public void registerInstance(String namespaceId, String groupName, String serviceName, Instance instance) throws NacosException {
        NamingUtils.checkInstanceIsLegal((Instance)instance);
        boolean ephemeral = instance.isEphemeral();
        String clientId = IpPortBasedClient.getClientId(instance.toInetAddr(), ephemeral);
        this.createIpPortClientIfAbsent(clientId);
        Service service = Service.newService(namespaceId, groupName, serviceName, ephemeral);
        this.clientOperationService.registerInstance(service, instance, clientId);
    }

    @Override
    public void removeInstance(String namespaceId, String groupName, String serviceName, Instance instance) {
        boolean ephemeral = instance.isEphemeral();
        String clientId = IpPortBasedClient.getClientId(instance.toInetAddr(), ephemeral);
        if (!this.clientManager.contains(clientId)) {
            Loggers.SRV_LOG.warn("remove instance from non-exist client: {}", (Object)clientId);
            return;
        }
        Service service = Service.newService(namespaceId, groupName, serviceName, ephemeral);
        this.clientOperationService.deregisterInstance(service, instance, clientId);
    }

    @Override
    public void updateInstance(String namespaceId, String groupName, String serviceName, Instance instance) throws NacosException {
        NamingUtils.checkInstanceIsLegal((Instance)instance);
        Service service = Service.newService(namespaceId, groupName, serviceName, instance.isEphemeral());
        if (!ServiceManager.getInstance().containSingleton(service)) {
            throw new NacosApiException(400, ErrorCode.INSTANCE_ERROR, "service not found, namespace: " + namespaceId + ", service: " + String.valueOf(service));
        }
        String metadataId = InstancePublishInfo.genMetadataId(instance.getIp(), instance.getPort(), instance.getClusterName());
        this.metadataOperateService.updateInstanceMetadata(service, metadataId, this.buildMetadata(instance));
        NotifyCenter.publishEvent((Event)new InfoChangeEvent.InstanceInfoChangeEvent(service, instance));
    }

    private InstanceMetadata buildMetadata(Instance instance) {
        InstanceMetadata result = new InstanceMetadata();
        result.setEnabled(instance.isEnabled());
        result.setWeight(instance.getWeight());
        result.getExtendData().putAll(this.filterNullValue(instance.getMetadata()));
        return result;
    }

    private Map<String, String> filterNullValue(Map<String, String> metadata) {
        return metadata.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public void patchInstance(String namespaceId, String groupName, String serviceName, InstancePatchObject patchObject) throws NacosException {
        Service service = Service.newService(namespaceId, groupName, serviceName, true);
        Instance instance = this.getInstance0(service, patchObject.getCluster(), patchObject.getIp(), patchObject.getPort());
        String metadataId = InstancePublishInfo.genMetadataId(instance.getIp(), instance.getPort(), instance.getClusterName());
        Optional<InstanceMetadata> instanceMetadata = this.metadataManager.getInstanceMetadata(service, metadataId);
        InstanceMetadata newMetadata = instanceMetadata.map(this::cloneMetadata).orElseGet(InstanceMetadata::new);
        this.mergeMetadata(newMetadata, patchObject);
        this.metadataOperateService.updateInstanceMetadata(service, metadataId, newMetadata);
    }

    private InstanceMetadata cloneMetadata(InstanceMetadata instanceMetadata) {
        InstanceMetadata result = new InstanceMetadata();
        result.setExtendData(new HashMap<String, Object>(instanceMetadata.getExtendData()));
        result.setWeight(instanceMetadata.getWeight());
        result.setEnabled(instanceMetadata.isEnabled());
        return result;
    }

    private void mergeMetadata(InstanceMetadata newMetadata, InstancePatchObject patchObject) {
        if (null != patchObject.getMetadata()) {
            newMetadata.setExtendData(new HashMap<String, Object>(patchObject.getMetadata()));
        }
        if (null != patchObject.getEnabled()) {
            newMetadata.setEnabled(patchObject.getEnabled());
        }
        if (null != patchObject.getWeight()) {
            newMetadata.setWeight(patchObject.getWeight());
        }
    }

    @Override
    public ServiceInfo listInstance(String namespaceId, String groupName, String serviceName, Subscriber subscriber, String cluster, boolean healthOnly) {
        Service service = Service.newService(namespaceId, groupName, serviceName, true);
        if (null != subscriber && subscriber.getPort() > 0 && this.pushService.canEnablePush(subscriber.getAgent())) {
            String clientId = IpPortBasedClient.getClientId(subscriber.getAddrStr(), true);
            this.createIpPortClientIfAbsent(clientId);
            this.clientOperationService.subscribeService(service, subscriber, clientId);
        }
        ServiceInfo serviceInfo = this.serviceStorage.getData(service);
        ServiceMetadata serviceMetadata = this.metadataManager.getServiceMetadata(service).orElse(null);
        ServiceInfo result = ServiceUtil.selectInstancesWithHealthyProtection(serviceInfo, serviceMetadata, cluster, healthOnly, true, null == subscriber ? "" : subscriber.getIp());
        result.setName(NamingUtils.getGroupedName((String)result.getName(), (String)result.getGroupName()));
        return result;
    }

    @Override
    public Instance getInstance(String namespaceId, String groupName, String serviceName, String cluster, String ip, int port) throws NacosException {
        Service service = Service.newService(namespaceId, groupName, serviceName, true);
        return this.getInstance0(service, cluster, ip, port);
    }

    private Instance getInstance0(Service service, String cluster, String ip, int port) throws NacosException {
        ServiceInfo serviceInfo = this.serviceStorage.getData(service);
        if (serviceInfo.getHosts().isEmpty()) {
            throw new NacosApiException(404, ErrorCode.RESOURCE_NOT_FOUND, "no ips found for cluster " + cluster + " in service " + service.getGroupedServiceName());
        }
        for (Instance each : serviceInfo.getHosts()) {
            if (!cluster.equals(each.getClusterName()) || !ip.equals(each.getIp()) || port != each.getPort()) continue;
            return each;
        }
        throw new NacosApiException(404, ErrorCode.RESOURCE_NOT_FOUND, "no matched ip found!");
    }

    @Override
    public int handleBeat(String namespaceId, String groupName, String serviceName, String ip, int port, String cluster, RsInfo clientBeat, BeatInfoInstanceBuilder builder) throws NacosException {
        Service service = Service.newService(namespaceId, groupName, serviceName, true);
        String clientId = IpPortBasedClient.getClientId(ip + ":" + port, true);
        IpPortBasedClient client = (IpPortBasedClient)this.clientManager.getClient(clientId);
        String groupedServiceName = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        if (null == client || !client.getAllPublishedService().contains(service)) {
            if (null == clientBeat) {
                return 20404;
            }
            Instance instance = builder.setBeatInfo(clientBeat).setServiceName(groupedServiceName).build();
            this.registerInstance(namespaceId, groupName, serviceName, instance);
            client = (IpPortBasedClient)this.clientManager.getClient(clientId);
        }
        if (!ServiceManager.getInstance().containSingleton(service)) {
            throw new NacosException(500, "service not found: " + groupedServiceName + "@" + namespaceId);
        }
        if (null == clientBeat) {
            clientBeat = new RsInfo();
            clientBeat.setIp(ip);
            clientBeat.setPort(port);
            clientBeat.setCluster(cluster);
            clientBeat.setServiceName(groupedServiceName);
        }
        ClientBeatProcessorV2 beatProcessor = new ClientBeatProcessorV2(namespaceId, clientBeat, client);
        HealthCheckReactor.scheduleNow(beatProcessor);
        client.setLastUpdatedTime();
        return 10200;
    }

    @Override
    public long getHeartBeatInterval(String namespaceId, String serviceName, String ip, int port, String cluster) {
        InstancePublishInfo instance;
        String metadataId;
        Service service = this.getService(namespaceId, serviceName, true);
        Optional<InstanceMetadata> metadata = this.metadataManager.getInstanceMetadata(service, metadataId = InstancePublishInfo.genMetadataId(ip, port, cluster));
        if (metadata.isPresent() && metadata.get().getExtendData().containsKey("preserved.heart.beat.interval")) {
            return ConvertUtils.toLong((Object)metadata.get().getExtendData().get("preserved.heart.beat.interval"));
        }
        String clientId = IpPortBasedClient.getClientId(ip + ":" + port, true);
        Client client = this.clientManager.getClient(clientId);
        InstancePublishInfo instancePublishInfo = instance = null != client ? client.getInstancePublishInfo(service) : null;
        if (null != instance && instance.getExtendDatum().containsKey("preserved.heart.beat.interval")) {
            return ConvertUtils.toLong((Object)instance.getExtendDatum().get("preserved.heart.beat.interval"));
        }
        return this.switchDomain.getClientBeatInterval();
    }

    @Override
    public List<? extends Instance> listAllInstances(String namespaceId, String serviceName) throws NacosException {
        Service service = this.getService(namespaceId, serviceName, true);
        return this.serviceStorage.getData(service).getHosts();
    }

    @Override
    public List<String> batchUpdateMetadata(String namespaceId, InstanceOperationInfo instanceOperationInfo, Map<String, String> metadata) throws NacosException {
        boolean isEphemeral = !"persist".equals(instanceOperationInfo.getConsistencyType());
        String serviceName = instanceOperationInfo.getServiceName();
        Service service = this.getService(namespaceId, serviceName, isEphemeral);
        LinkedList<String> result = new LinkedList<String>();
        List<Instance> needUpdateInstance = this.findBatchUpdateInstance(instanceOperationInfo, service);
        for (Instance each : needUpdateInstance) {
            String metadataId = InstancePublishInfo.genMetadataId(each.getIp(), each.getPort(), each.getClusterName());
            Optional<InstanceMetadata> instanceMetadata = this.metadataManager.getInstanceMetadata(service, metadataId);
            InstanceMetadata newMetadata = instanceMetadata.map(this::cloneMetadata).orElseGet(InstanceMetadata::new);
            newMetadata.getExtendData().putAll(metadata);
            this.metadataOperateService.updateInstanceMetadata(service, metadataId, newMetadata);
            result.add(each.toInetAddr() + ":unknown:" + each.getClusterName() + ":" + (each.isEphemeral() ? "ephemeral" : "persist"));
        }
        return result;
    }

    @Override
    public List<String> batchDeleteMetadata(String namespaceId, InstanceOperationInfo instanceOperationInfo, Map<String, String> metadata) throws NacosException {
        boolean isEphemeral = !"persist".equals(instanceOperationInfo.getConsistencyType());
        String serviceName = instanceOperationInfo.getServiceName();
        Service service = this.getService(namespaceId, serviceName, isEphemeral);
        LinkedList<String> result = new LinkedList<String>();
        List<Instance> needUpdateInstance = this.findBatchUpdateInstance(instanceOperationInfo, service);
        for (Instance each : needUpdateInstance) {
            String metadataId = InstancePublishInfo.genMetadataId(each.getIp(), each.getPort(), each.getClusterName());
            Optional<InstanceMetadata> instanceMetadata = this.metadataManager.getInstanceMetadata(service, metadataId);
            InstanceMetadata newMetadata = instanceMetadata.map(this::cloneMetadata).orElseGet(InstanceMetadata::new);
            metadata.keySet().forEach(key -> newMetadata.getExtendData().remove(key));
            this.metadataOperateService.updateInstanceMetadata(service, metadataId, newMetadata);
            result.add(each.toInetAddr() + ":unknown:" + each.getClusterName() + ":" + (each.isEphemeral() ? "ephemeral" : "persist"));
        }
        return result;
    }

    private List<Instance> findBatchUpdateInstance(InstanceOperationInfo instanceOperationInfo, Service service) {
        if (null == instanceOperationInfo.getInstances() || instanceOperationInfo.getInstances().isEmpty()) {
            return this.serviceStorage.getData(service).getHosts();
        }
        LinkedList<Instance> result = new LinkedList<Instance>();
        for (Instance instance : instanceOperationInfo.getInstances()) {
            try {
                this.getInstance0(service, instance.getClusterName(), instance.getIp(), instance.getPort());
                result.add(instance);
            }
            catch (NacosException nacosException) {}
        }
        return result;
    }

    private void createIpPortClientIfAbsent(String clientId) {
        if (!this.clientManager.contains(clientId)) {
            ClientAttributes clientAttributes = ClientAttributesFilter.getCurrentClientAttributes().orElse(new ClientAttributes());
            this.clientManager.clientConnected(clientId, clientAttributes);
        }
    }

    private Service getService(String namespaceId, String serviceName, boolean ephemeral) {
        String groupName = NamingUtils.getGroupName((String)serviceName);
        String serviceNameNoGrouped = NamingUtils.getServiceName((String)serviceName);
        return Service.newService(namespaceId, groupName, serviceNameNoGrouped, ephemeral);
    }
}

