/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClientPublisherInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClientServiceInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClientSubscriberInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClientSummaryInfo;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.naming.core.ClientService;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.model.form.ClientServiceForm;
import com.alibaba.nacos.naming.paramcheck.NamingDefaultHttpParamExtractor;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/admin/ns/client"})
@ExtractorManager.Extractor(httpExtractor=NamingDefaultHttpParamExtractor.class)
public class ClientControllerV3 {
    private final ClientManager clientManager;
    private final ClientService clientServiceV2Impl;

    public ClientControllerV3(@Qualifier(value="clientManager") ClientManager clientManager, ClientService clientServiceV2Impl) {
        this.clientManager = clientManager;
        this.clientServiceV2Impl = clientServiceV2Impl;
    }

    @GetMapping(value={"/list"})
    @Secured(action=ActionTypes.READ, apiType=ApiType.ADMIN_API)
    public Result<List<String>> getClientList() {
        return Result.success(this.clientServiceV2Impl.getClientList());
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, apiType=ApiType.ADMIN_API)
    public Result<ClientSummaryInfo> getClientDetail(@RequestParam(value="clientId") String clientId) throws NacosApiException {
        this.checkClientId(clientId);
        return Result.success((Object)this.clientServiceV2Impl.getClientDetail(clientId));
    }

    @GetMapping(value={"/publish/list"})
    @Secured(action=ActionTypes.READ, apiType=ApiType.ADMIN_API)
    public Result<List<ClientServiceInfo>> getPublishedServiceList(@RequestParam(value="clientId") String clientId) throws NacosApiException {
        this.checkClientId(clientId);
        return Result.success(this.clientServiceV2Impl.getPublishedServiceList(clientId));
    }

    @GetMapping(value={"/subscribe/list"})
    @Secured(action=ActionTypes.READ, apiType=ApiType.ADMIN_API)
    public Result<List<ClientServiceInfo>> getSubscribeServiceList(@RequestParam(value="clientId") String clientId) throws NacosApiException {
        this.checkClientId(clientId);
        return Result.success(this.clientServiceV2Impl.getSubscribeServiceList(clientId));
    }

    @GetMapping(value={"/service/publisher/list"})
    @Secured(action=ActionTypes.READ, apiType=ApiType.ADMIN_API)
    public Result<List<ClientPublisherInfo>> getPublishedClientList(ClientServiceForm clientServiceForm) throws NacosApiException {
        clientServiceForm.validate();
        return Result.success(this.clientServiceV2Impl.getPublishedClientList(clientServiceForm.getNamespaceId(), clientServiceForm.getGroupName(), clientServiceForm.getServiceName(), clientServiceForm.getIp(), clientServiceForm.getPort()));
    }

    @GetMapping(value={"/service/subscriber/list"})
    @Secured(action=ActionTypes.READ, apiType=ApiType.ADMIN_API)
    public Result<List<ClientSubscriberInfo>> getSubscribeClientList(ClientServiceForm clientServiceForm) throws NacosApiException {
        clientServiceForm.validate();
        return Result.success(this.clientServiceV2Impl.getSubscribeClientList(clientServiceForm.getNamespaceId(), clientServiceForm.getGroupName(), clientServiceForm.getServiceName(), clientServiceForm.getIp(), clientServiceForm.getPort()));
    }

    @GetMapping(value={"/distro"})
    @Secured(resource="/v3/admin/ns/client", action=ActionTypes.READ, apiType=ApiType.ADMIN_API)
    public Result<ObjectNode> getResponsibleServer4Client(@RequestParam String ip, @RequestParam String port) {
        return Result.success((Object)this.clientServiceV2Impl.getResponsibleServer4Client(ip, port));
    }

    private void checkClientId(String clientId) throws NacosApiException {
        if (!this.clientManager.contains(clientId)) {
            throw new NacosApiException(HttpStatus.NOT_FOUND.value(), ErrorCode.RESOURCE_NOT_FOUND, "clientId [ " + clientId + " ] not exist");
        }
    }
}

