/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers.v2;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClientSummaryInfo;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.core.controller.compatibility.Compatibility;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.naming.core.ClientService;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.paramcheck.NamingDefaultHttpParamExtractor;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Deprecated
@NacosApi
@RestController
@RequestMapping(value={"/v2/ns/client"})
@ExtractorManager.Extractor(httpExtractor=NamingDefaultHttpParamExtractor.class)
public class ClientInfoControllerV2 {
    private final ClientManager clientManager;
    private final ClientService clientServiceV2Impl;

    public ClientInfoControllerV2(@Qualifier(value="clientManager") ClientManager clientManager, ClientService clientServiceV2Impl) {
        this.clientManager = clientManager;
        this.clientServiceV2Impl = clientServiceV2Impl;
    }

    @GetMapping(value={"/list"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin")
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="GET ${contextPath:nacos}/v3/admin/ns/client/list")
    public Result<List<String>> getClientList() {
        return Result.success(this.clientServiceV2Impl.getClientList());
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, resource="nacos/admin")
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="GET ${contextPath:nacos}/v3/admin/ns/client")
    public Result<ClientSummaryInfo> getClientDetail(@RequestParam(value="clientId") String clientId) throws NacosApiException {
        this.checkClientId(clientId);
        return Result.success((Object)this.clientServiceV2Impl.getClientDetail(clientId));
    }

    @GetMapping(value={"/publish/list"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin")
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="GET ${contextPath:nacos}/v3/admin/ns/client/publish/list")
    public Result<List<ObjectNode>> getPublishedServiceList(@RequestParam(value="clientId") String clientId) throws NacosApiException {
        this.checkClientId(clientId);
        return Result.success(this.clientServiceV2Impl.getPublishedServiceListAdapt(clientId));
    }

    @GetMapping(value={"/subscribe/list"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin")
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="GET ${contextPath:nacos}/v3/admin/ns/client/subscribe/list")
    public Result<List<ObjectNode>> getSubscribeServiceList(@RequestParam(value="clientId") String clientId) throws NacosApiException {
        this.checkClientId(clientId);
        return Result.success(this.clientServiceV2Impl.getSubscribeServiceListAdapt(clientId));
    }

    @GetMapping(value={"/service/publisher/list"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin")
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="GET ${contextPath:nacos}/v3/admin/ns/client/service/publisher/list")
    public Result<List<ObjectNode>> getPublishedClientList(@RequestParam(value="namespaceId", required=false, defaultValue="public") String namespaceId, @RequestParam(value="groupName", required=false, defaultValue="DEFAULT_GROUP") String groupName, @RequestParam(value="ephemeral", required=false, defaultValue="true") Boolean ephemeral, @RequestParam(value="serviceName") String serviceName, @RequestParam(value="ip", required=false) String ip, @RequestParam(value="port", required=false) Integer port) {
        return Result.success(this.clientServiceV2Impl.getPublishedClientList(namespaceId, groupName, serviceName, ephemeral, ip, port));
    }

    @GetMapping(value={"/service/subscriber/list"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin")
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="GET ${contextPath:nacos}/v3/admin/ns/client/service/subscriber/list")
    public Result<List<ObjectNode>> getSubscribeClientList(@RequestParam(value="namespaceId", required=false, defaultValue="public") String namespaceId, @RequestParam(value="groupName", required=false, defaultValue="DEFAULT_GROUP") String groupName, @RequestParam(value="ephemeral", required=false, defaultValue="true") Boolean ephemeral, @RequestParam(value="serviceName") String serviceName, @RequestParam(value="ip", required=false) String ip, @RequestParam(value="port", required=false) Integer port) {
        return Result.success(this.clientServiceV2Impl.getSubscribeClientList(namespaceId, groupName, serviceName, ephemeral, ip, port));
    }

    private void checkClientId(String clientId) throws NacosApiException {
        if (!this.clientManager.contains(clientId)) {
            throw new NacosApiException(HttpStatus.NOT_FOUND.value(), ErrorCode.RESOURCE_NOT_FOUND, "clientId [ " + clientId + " ] not exist");
        }
    }
}

