/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2.task;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.common.task.engine.NacosDelayTaskExecuteEngine;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NamingExecuteTaskDispatcher;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.push.v2.executor.PushExecutor;
import com.alibaba.nacos.naming.push.v2.executor.PushExecutorDelegate;
import com.alibaba.nacos.naming.push.v2.task.FuzzyWatchChangeNotifyExecuteTask;
import com.alibaba.nacos.naming.push.v2.task.FuzzyWatchChangeNotifyTask;
import com.alibaba.nacos.naming.push.v2.task.FuzzyWatchSyncNotifyExecuteTask;
import com.alibaba.nacos.naming.push.v2.task.FuzzyWatchSyncNotifyTask;
import org.springframework.stereotype.Component;

@Component
public class FuzzyWatchPushDelayTaskEngine
extends NacosDelayTaskExecuteEngine {
    private final PushExecutorDelegate pushExecutor;
    private final SwitchDomain switchDomain;

    public FuzzyWatchPushDelayTaskEngine(PushExecutorDelegate pushExecutor, SwitchDomain switchDomain) {
        super(FuzzyWatchPushDelayTaskEngine.class.getSimpleName(), Loggers.PUSH);
        this.pushExecutor = pushExecutor;
        this.switchDomain = switchDomain;
        this.setDefaultTaskProcessor(new WatchPushDelayTaskProcessor(this));
    }

    public PushExecutor getPushExecutor() {
        return this.pushExecutor;
    }

    protected void processTasks() {
        if (!this.switchDomain.isPushEnabled()) {
            return;
        }
        super.processTasks();
    }

    public static String getTaskKey(NacosTask task) {
        if (task instanceof FuzzyWatchChangeNotifyTask) {
            return "fwcnT-" + ((FuzzyWatchChangeNotifyTask)task).getClientId() + ((FuzzyWatchChangeNotifyTask)task).getServiceKey();
        }
        if (task instanceof FuzzyWatchSyncNotifyTask) {
            return "fwsnT-" + ((FuzzyWatchSyncNotifyTask)task).getSyncType() + "-" + ((FuzzyWatchSyncNotifyTask)task).getClientId() + ((FuzzyWatchSyncNotifyTask)task).getPattern() + "-" + ((FuzzyWatchSyncNotifyTask)task).getCurrentBatch();
        }
        throw new NacosRuntimeException(500, "unknown fuzzy task type");
    }

    private static class WatchPushDelayTaskProcessor
    implements NacosTaskProcessor {
        private final FuzzyWatchPushDelayTaskEngine fuzzyWatchPushExecuteEngine;

        public WatchPushDelayTaskProcessor(FuzzyWatchPushDelayTaskEngine fuzzyWatchPushExecuteEngine) {
            this.fuzzyWatchPushExecuteEngine = fuzzyWatchPushExecuteEngine;
        }

        public boolean process(NacosTask task) {
            if (task instanceof FuzzyWatchChangeNotifyTask) {
                FuzzyWatchChangeNotifyTask fuzzyWatchChangeNotifyTask = (FuzzyWatchChangeNotifyTask)task;
                NamingExecuteTaskDispatcher.getInstance().dispatchAndExecuteTask(FuzzyWatchPushDelayTaskEngine.getTaskKey(task), new FuzzyWatchChangeNotifyExecuteTask(this.fuzzyWatchPushExecuteEngine, fuzzyWatchChangeNotifyTask.getServiceKey(), fuzzyWatchChangeNotifyTask.getChangedType(), fuzzyWatchChangeNotifyTask.getClientId()));
            } else if (task instanceof FuzzyWatchSyncNotifyTask) {
                FuzzyWatchSyncNotifyTask fuzzyWatchSyncNotifyTask = (FuzzyWatchSyncNotifyTask)task;
                String pattern = fuzzyWatchSyncNotifyTask.getPattern();
                String clientId = fuzzyWatchSyncNotifyTask.getClientId();
                NamingExecuteTaskDispatcher.getInstance().dispatchAndExecuteTask(FuzzyWatchPushDelayTaskEngine.getTaskKey(task), new FuzzyWatchSyncNotifyExecuteTask(clientId, pattern, this.fuzzyWatchPushExecuteEngine, fuzzyWatchSyncNotifyTask));
            }
            return true;
        }
    }
}

