/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.paramcheck;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.paramcheck.ParamInfo;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.paramcheck.AbstractHttpParamExtractor;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

public class NamingInstanceMetadataBatchHttpParamExtractor
extends AbstractHttpParamExtractor {
    public List<ParamInfo> extractParam(HttpServletRequest request) throws NacosException {
        ParamInfo paramInfo = new ParamInfo();
        String serviceName = request.getParameter("serviceName");
        String groupName = request.getParameter("groupName");
        String groupServiceName = serviceName;
        if (StringUtils.isNotBlank((String)groupServiceName) && groupServiceName.contains("@@")) {
            String[] splits = groupServiceName.split("@@", 2);
            groupName = splits[0];
            serviceName = splits[1];
        }
        paramInfo.setServiceName(serviceName);
        paramInfo.setGroup(groupName);
        paramInfo.setNamespaceId(request.getParameter("namespaceId"));
        paramInfo.setMetadata(UtilsAndCommons.parseMetadata(request.getParameter("metadata")));
        ArrayList<ParamInfo> paramInfos = new ArrayList<ParamInfo>();
        paramInfos.add(paramInfo);
        String instances = request.getParameter("instances");
        if (StringUtils.isNotBlank((String)instances)) {
            List targetInstances = (List)JacksonUtils.toObj((String)instances, (TypeReference)new TypeReference<List<Instance>>(){});
            for (Instance instance : targetInstances) {
                ParamInfo instanceParamInfo = new ParamInfo();
                instanceParamInfo.setIp(instance.getIp());
                instanceParamInfo.setPort(String.valueOf(instance.getPort()));
                instanceParamInfo.setCluster(instance.getClusterName());
                paramInfos.add(instanceParamInfo);
            }
        }
        return paramInfos;
    }
}

