/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck.extend;

import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckType;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.naming.healthcheck.extend.AbstractHealthCheckProcessorExtend;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckExtendProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckExtendProvider.class);
    private final Collection<AbstractHealthChecker> checkers = NacosServiceLoader.load(AbstractHealthChecker.class);
    private AbstractHealthCheckProcessorExtend healthCheckProcessorExtend;

    public void setHealthCheckProcessorExtend(AbstractHealthCheckProcessorExtend healthCheckProcessorExtend) {
        this.healthCheckProcessorExtend = healthCheckProcessorExtend;
    }

    public void init() {
        this.loadExtend();
    }

    private void loadExtend() {
        Iterator<AbstractHealthChecker> healthCheckerIt = this.checkers.iterator();
        HashSet<String> origin = new HashSet<String>();
        for (Object type : HealthCheckType.values()) {
            origin.add(type.name());
        }
        Set<String> processorType = this.healthCheckProcessorExtend.addProcessor(origin);
        HashSet<String> healthCheckerType = new HashSet<String>(origin);
        while (healthCheckerIt.hasNext()) {
            Object type;
            AbstractHealthChecker checker = healthCheckerIt.next();
            type = checker.getType();
            if (healthCheckerType.contains(type)) {
                throw new RuntimeException("More than one healthChecker of the same type was found : [type=\"" + (String)type + "\"]");
            }
            healthCheckerType.add((String)type);
            HealthCheckType.registerHealthChecker((String)checker.getType(), checker.getClass());
        }
        if (!processorType.equals(healthCheckerType)) {
            throw new RuntimeException("An unmatched processor and healthChecker are detected in the extension package.");
        }
        if (processorType.size() > origin.size()) {
            processorType.removeAll(origin);
            LOGGER.debug("init health plugin : types=" + String.valueOf(processorType));
        }
    }
}

