/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.index;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.EventPublisherFactory;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.trace.DeregisterInstanceReason;
import com.alibaba.nacos.common.trace.event.naming.DeregisterInstanceTraceEvent;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.event.client.ClientOperationEvent;
import com.alibaba.nacos.naming.core.v2.event.publisher.NamingEventPublisherFactory;
import com.alibaba.nacos.naming.core.v2.event.service.ServiceEvent;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.stereotype.Component;

@Component
public class ClientServiceIndexesManager
extends SmartSubscriber {
    private final ConcurrentMap<Service, Set<String>> publisherIndexes = new ConcurrentHashMap<Service, Set<String>>();
    private final ConcurrentMap<Service, Set<String>> subscriberIndexes = new ConcurrentHashMap<Service, Set<String>>();

    public ClientServiceIndexesManager() {
        NotifyCenter.registerSubscriber((Subscriber)this, (EventPublisherFactory)NamingEventPublisherFactory.getInstance());
    }

    public Collection<String> getAllClientsRegisteredService(Service service) {
        return this.publisherIndexes.containsKey(service) ? (Collection)this.publisherIndexes.get(service) : new ConcurrentHashSet();
    }

    public Collection<String> getAllClientsSubscribeService(Service service) {
        return this.subscriberIndexes.containsKey(service) ? (Collection)this.subscriberIndexes.get(service) : new ConcurrentHashSet();
    }

    public Collection<Service> getSubscribedService() {
        return this.subscriberIndexes.keySet();
    }

    public void removePublisherIndexesByEmptyService(Service service) {
        if (this.publisherIndexes.containsKey(service) && ((Set)this.publisherIndexes.get(service)).isEmpty()) {
            this.publisherIndexes.remove(service);
        }
    }

    public List<Class<? extends Event>> subscribeTypes() {
        LinkedList<Class<? extends Event>> result = new LinkedList<Class<? extends Event>>();
        result.add(ClientOperationEvent.ClientRegisterServiceEvent.class);
        result.add(ClientOperationEvent.ClientDeregisterServiceEvent.class);
        result.add(ClientOperationEvent.ClientSubscribeServiceEvent.class);
        result.add(ClientOperationEvent.ClientUnsubscribeServiceEvent.class);
        result.add(ClientOperationEvent.ClientReleaseEvent.class);
        return result;
    }

    public void onEvent(Event event) {
        if (event instanceof ClientOperationEvent.ClientReleaseEvent) {
            this.handleClientDisconnect((ClientOperationEvent.ClientReleaseEvent)event);
        } else if (event instanceof ClientOperationEvent) {
            this.handleClientOperation((ClientOperationEvent)event);
        }
    }

    private void handleClientDisconnect(ClientOperationEvent.ClientReleaseEvent event) {
        Client client = event.getClient();
        for (Service each : client.getAllSubscribeService()) {
            this.removeSubscriberIndexes(each, client.getClientId());
        }
        DeregisterInstanceReason reason = event.isNative() ? DeregisterInstanceReason.NATIVE_DISCONNECTED : DeregisterInstanceReason.SYNCED_DISCONNECTED;
        long currentTimeMillis = System.currentTimeMillis();
        for (Service each : client.getAllPublishedService()) {
            this.removePublisherIndexes(each, client.getClientId());
            InstancePublishInfo instance = client.getInstancePublishInfo(each);
            NotifyCenter.publishEvent((Event)new DeregisterInstanceTraceEvent(currentTimeMillis, "", false, reason, each.getNamespace(), each.getGroup(), each.getName(), instance.getIp(), instance.getPort()));
        }
    }

    private void handleClientOperation(ClientOperationEvent event) {
        Service service = event.getService();
        String clientId = event.getClientId();
        if (event instanceof ClientOperationEvent.ClientRegisterServiceEvent) {
            this.addPublisherIndexes(service, clientId);
        } else if (event instanceof ClientOperationEvent.ClientDeregisterServiceEvent) {
            this.removePublisherIndexes(service, clientId);
        } else if (event instanceof ClientOperationEvent.ClientSubscribeServiceEvent) {
            this.addSubscriberIndexes(service, clientId);
        } else if (event instanceof ClientOperationEvent.ClientUnsubscribeServiceEvent) {
            this.removeSubscriberIndexes(service, clientId);
        }
    }

    private void addPublisherIndexes(Service service, String clientId) {
        String serviceChangedType = "INSTANCE_CHANGED";
        if (!this.publisherIndexes.containsKey(service)) {
            serviceChangedType = "ADD_SERVICE";
        }
        NotifyCenter.publishEvent((Event)new ServiceEvent.ServiceChangedEvent(service, serviceChangedType, true));
        this.publisherIndexes.computeIfAbsent(service, key -> new ConcurrentHashSet()).add(clientId);
    }

    private void removePublisherIndexes(Service service, String clientId) {
        this.publisherIndexes.computeIfPresent(service, (s, ids) -> {
            ids.remove(clientId);
            String serviceChangedType = ids.isEmpty() ? "DELETE_SERVICE" : "INSTANCE_CHANGED";
            NotifyCenter.publishEvent((Event)new ServiceEvent.ServiceChangedEvent(service, serviceChangedType, true));
            return ids.isEmpty() ? null : ids;
        });
    }

    private void addSubscriberIndexes(Service service, String clientId) {
        Set clientIds = this.subscriberIndexes.computeIfAbsent(service, key -> new ConcurrentHashSet());
        if (clientIds.add(clientId)) {
            NotifyCenter.publishEvent((Event)new ServiceEvent.ServiceSubscribedEvent(service, clientId));
        }
    }

    private void removeSubscriberIndexes(Service service, String clientId) {
        Set clientIds = (Set)this.subscriberIndexes.get(service);
        if (clientIds == null) {
            return;
        }
        clientIds.remove(clientId);
        if (clientIds.isEmpty()) {
            this.subscriberIndexes.remove(service);
        }
    }
}

