/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.push.NamingSubscriberServiceAggregationImpl;
import com.alibaba.nacos.naming.push.NamingSubscriberServiceLocalImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Service
public class SubscribeManager {
    @Autowired
    private NamingSubscriberServiceLocalImpl localService;
    @Autowired
    private NamingSubscriberServiceAggregationImpl aggregationService;

    public List<Subscriber> getSubscribers(String serviceName, String namespaceId, boolean aggregation) {
        if (aggregation) {
            Collection<Subscriber> result = this.aggregationService.getFuzzySubscribers(namespaceId, serviceName);
            return CollectionUtils.isNotEmpty(result) ? result.stream().filter(SubscribeManager.distinctByKey(Subscriber::toString)).collect(Collectors.toList()) : Collections.emptyList();
        }
        return new LinkedList<Subscriber>(this.localService.getFuzzySubscribers(namespaceId, serviceName));
    }

    public List<Subscriber> getSubscribers(Service service, boolean aggregation) {
        if (aggregation) {
            Collection<Subscriber> result = this.aggregationService.getSubscribers(service);
            return CollectionUtils.isNotEmpty(result) ? result.stream().filter(SubscribeManager.distinctByKey(Subscriber::toString)).collect(Collectors.toList()) : Collections.emptyList();
        }
        return new LinkedList<Subscriber>(this.localService.getSubscribers(service));
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap(128);
        return object -> seen.putIfAbsent(keyExtractor.apply(object), Boolean.TRUE) == null;
    }
}

