/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClusterInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ServiceDetailInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ServiceView;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.utils.PageUtil;
import com.alibaba.nacos.naming.core.CatalogService;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.utils.ServiceUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class CatalogServiceV2Impl
implements CatalogService {
    private final ServiceStorage serviceStorage;
    private final NamingMetadataManager metadataManager;
    private static final int DEFAULT_PORT = 80;

    public CatalogServiceV2Impl(ServiceStorage serviceStorage, NamingMetadataManager metadataManager) {
        this.serviceStorage = serviceStorage;
        this.metadataManager = metadataManager;
    }

    @Override
    public ServiceDetailInfo getServiceDetail(String namespaceId, String groupName, String serviceName) throws NacosException {
        Service service = Service.newService(namespaceId, groupName, serviceName);
        if (!ServiceManager.getInstance().containSingleton(service)) {
            throw new NacosException(404, String.format("service %s@@%s is not found!", groupName, serviceName));
        }
        service = ServiceManager.getInstance().getSingleton(service);
        Optional<ServiceMetadata> metadata = this.metadataManager.getServiceMetadata(service);
        ServiceMetadata detailedService = metadata.orElseGet(ServiceMetadata::new);
        ServiceDetailInfo result = new ServiceDetailInfo();
        result.setNamespaceId(service.getNamespace());
        result.setGroupName(service.getGroup());
        result.setServiceName(serviceName);
        result.setEphemeral(service.isEphemeral());
        result.setProtectThreshold(detailedService.getProtectThreshold());
        result.setSelector(detailedService.getSelector());
        result.setMetadata(detailedService.getExtendData());
        HashMap<String, ClusterInfo> clusters = new HashMap<String, ClusterInfo>(this.serviceStorage.getClusters(service).size());
        for (String each : this.serviceStorage.getClusters(service)) {
            ClusterMetadata clusterMetadata = detailedService.getClusters().containsKey(each) ? detailedService.getClusters().get(each) : new ClusterMetadata();
            ClusterInfo clusterInfo = new ClusterInfo();
            clusterInfo.setClusterName(each);
            clusterInfo.setHealthChecker(clusterMetadata.getHealthChecker());
            clusterInfo.setMetadata(clusterMetadata.getExtendData());
            clusterInfo.setUseInstancePortForCheck(clusterMetadata.isUseInstancePortForCheck());
            clusterInfo.setHealthyCheckPort(clusterMetadata.getHealthyCheckPort());
            clusters.put(each, clusterInfo);
        }
        result.setClusterMap(clusters);
        return result;
    }

    @Override
    public List<? extends Instance> listInstances(String namespaceId, String groupName, String serviceName, String clusterName) throws NacosException {
        Service service = Service.newService(namespaceId, groupName, serviceName);
        if (!ServiceManager.getInstance().containSingleton(service)) {
            throw new NacosException(404, String.format("service %s@@%s is not found!", groupName, serviceName));
        }
        if (!this.serviceStorage.getClusters(service).contains(clusterName)) {
            throw new NacosException(404, "cluster " + clusterName + " is not found!");
        }
        ServiceInfo serviceInfo = this.serviceStorage.getData(service);
        ServiceInfo result = ServiceUtil.selectInstances(serviceInfo, clusterName);
        return result.getHosts();
    }

    @Override
    public List<? extends Instance> listAllInstances(String namespaceId, String groupName, String serviceName) {
        Service service = Service.newService(namespaceId, groupName, serviceName);
        if (!ServiceManager.getInstance().containSingleton(service)) {
            return Collections.EMPTY_LIST;
        }
        ServiceInfo serviceInfo = this.serviceStorage.getData(service);
        return serviceInfo.getHosts();
    }

    @Override
    public Object pageListService(String namespaceId, String groupName, String serviceName, int pageNo, int pageSize, String instancePattern, boolean ignoreEmptyService) throws NacosException {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        LinkedList<ServiceView> serviceViews = new LinkedList<ServiceView>();
        Collection<Service> services = this.patternServices(namespaceId, groupName, serviceName);
        if (ignoreEmptyService) {
            services = services.stream().filter(each -> 0 != this.serviceStorage.getData((Service)each).ipCount()).collect(Collectors.toList());
        }
        result.put("count", services.size());
        services = this.doPage(services, pageNo - 1, pageSize);
        for (Service each2 : services) {
            ServiceMetadata serviceMetadata = this.metadataManager.getServiceMetadata(each2).orElseGet(ServiceMetadata::new);
            ServiceView serviceView = new ServiceView();
            serviceView.setName(each2.getName());
            serviceView.setGroupName(each2.getGroup());
            serviceView.setClusterCount(this.serviceStorage.getClusters(each2).size());
            serviceView.setIpCount(this.serviceStorage.getData(each2).ipCount());
            serviceView.setHealthyInstanceCount(this.countHealthyInstance(this.serviceStorage.getData(each2)));
            serviceView.setTriggerFlag(this.isProtectThreshold(serviceView, serviceMetadata) ? "true" : "false");
            serviceViews.add(serviceView);
        }
        result.set("serviceList", JacksonUtils.transferToJsonNode(serviceViews));
        return result;
    }

    @Override
    public Page<ServiceView> listService(String namespaceId, String groupName, String serviceName, int pageNo, int pageSize, boolean ignoreEmptyService) throws NacosException {
        Page serviceViews = new Page();
        Collection<Service> services = this.patternServices(namespaceId, groupName, serviceName);
        if (ignoreEmptyService) {
            services = services.stream().filter(each -> 0 != this.serviceStorage.getData((Service)each).ipCount()).toList();
        }
        Page page = PageUtil.subPage(services.stream().toList(), (int)pageNo, (int)pageSize);
        serviceViews.setTotalCount(page.getTotalCount());
        serviceViews.setPageNumber(page.getPageNumber());
        serviceViews.setPagesAvailable(page.getPagesAvailable());
        for (Service each2 : page.getPageItems()) {
            ServiceMetadata serviceMetadata = this.metadataManager.getServiceMetadata(each2).orElseGet(ServiceMetadata::new);
            ServiceView serviceView = new ServiceView();
            serviceView.setName(each2.getName());
            serviceView.setGroupName(each2.getGroup());
            serviceView.setClusterCount(this.serviceStorage.getClusters(each2).size());
            serviceView.setIpCount(this.serviceStorage.getData(each2).ipCount());
            serviceView.setHealthyInstanceCount(this.countHealthyInstance(this.serviceStorage.getData(each2)));
            serviceView.setTriggerFlag(this.isProtectThreshold(serviceView, serviceMetadata) ? "true" : "false");
            serviceViews.getPageItems().add(serviceView);
        }
        return serviceViews;
    }

    private int countHealthyInstance(ServiceInfo data) {
        int result = 0;
        for (Instance each : data.getHosts()) {
            if (!each.isHealthy()) continue;
            ++result;
        }
        return result;
    }

    private boolean isProtectThreshold(ServiceView serviceView, ServiceMetadata metadata) {
        return (double)serviceView.getHealthyInstanceCount() * 1.0 / (double)serviceView.getIpCount() <= (double)metadata.getProtectThreshold();
    }

    @Override
    public Page<ServiceDetailInfo> pageListServiceDetail(String namespaceId, String groupName, String serviceName, int pageNo, int pageSize) throws NacosException {
        Collection<Service> services = this.patternServices(namespaceId, groupName, serviceName);
        Page servicePage = PageUtil.subPage(services.stream().toList(), (int)pageNo, (int)pageSize);
        Page result = new Page();
        result.setPagesAvailable(servicePage.getPagesAvailable());
        result.setPageNumber(servicePage.getPageNumber());
        result.setTotalCount(servicePage.getTotalCount());
        LinkedList<ServiceDetailInfo> pagedItem = new LinkedList<ServiceDetailInfo>();
        for (Service each : servicePage.getPageItems()) {
            ServiceDetailInfo serviceDetailInfo = new ServiceDetailInfo();
            serviceDetailInfo.setServiceName(each.getName());
            serviceDetailInfo.setGroupName(each.getGroup());
            ServiceMetadata serviceMetadata = this.metadataManager.getServiceMetadata(each).orElseGet(ServiceMetadata::new);
            serviceDetailInfo.setMetadata(serviceMetadata.getExtendData());
            serviceDetailInfo.setClusterMap(this.getClusterMap(each));
            pagedItem.add(serviceDetailInfo);
        }
        result.setPageItems(pagedItem);
        return result;
    }

    private Map<String, ClusterInfo> getClusterMap(Service service) {
        HashMap<String, ClusterInfo> result = new HashMap<String, ClusterInfo>(1);
        for (Instance each : this.serviceStorage.getData(service).getHosts()) {
            if (!result.containsKey(each.getClusterName())) {
                ClusterInfo clusterInfo = new ClusterInfo();
                clusterInfo.setHosts(new LinkedList());
                result.put(each.getClusterName(), clusterInfo);
            }
            ((ClusterInfo)result.get(each.getClusterName())).getHosts().add(each);
        }
        return result;
    }

    private Collection<Service> patternServices(String namespaceId, String group, String serviceName) {
        boolean noFilter;
        boolean bl = noFilter = StringUtils.isBlank((CharSequence)serviceName) && StringUtils.isBlank((CharSequence)group);
        if (noFilter) {
            return ServiceManager.getInstance().getSingletons(namespaceId);
        }
        LinkedList<Service> result = new LinkedList<Service>();
        StringJoiner regex = new StringJoiner("@@");
        regex.add(this.getRegexString(group));
        regex.add(this.getRegexString(serviceName));
        String regexString = regex.toString();
        for (Service each : ServiceManager.getInstance().getSingletons(namespaceId)) {
            if (!each.getGroupedServiceName().matches(regexString)) continue;
            result.add(each);
        }
        return result;
    }

    private String getRegexString(String target) {
        return StringUtils.isBlank((CharSequence)target) ? ".*" : ".*" + target + ".*";
    }

    private Collection<Service> doPage(Collection<Service> services, int pageNo, int pageSize) {
        if (pageNo == 0 && services.size() < pageSize) {
            return services;
        }
        int start = pageNo * pageSize;
        if (start > services.size()) {
            return Collections.emptyList();
        }
        LinkedList<Service> result = new LinkedList<Service>();
        int i = 0;
        for (Service each : services) {
            if (i++ < start) continue;
            result.add(each);
            if (result.size() < pageSize) continue;
            break;
        }
        return result;
    }
}

