/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.monitor;

import com.alibaba.nacos.naming.monitor.TpsMonitorItem;
import com.alibaba.nacos.plugin.control.ControlManagerCenter;
import com.alibaba.nacos.plugin.control.tps.TpsControlManager;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;

public class NamingTpsMonitor {
    private static final NamingTpsMonitor INSTANCE = new NamingTpsMonitor();
    private final TpsControlManager tpsControlManager = ControlManagerCenter.getInstance().getTpsControlManager();

    private NamingTpsMonitor() {
        this.registerPushMonitorPoint();
        this.registerDistroMonitorPoint();
    }

    private void registerPushMonitorPoint() {
        this.tpsControlManager.registerTpsPoint(TpsMonitorItem.NAMING_RPC_PUSH.name());
        this.tpsControlManager.registerTpsPoint(TpsMonitorItem.NAMING_RPC_PUSH_SUCCESS.name());
        this.tpsControlManager.registerTpsPoint(TpsMonitorItem.NAMING_RPC_PUSH_FAIL.name());
        this.tpsControlManager.registerTpsPoint(TpsMonitorItem.NAMING_UDP_PUSH.name());
        this.tpsControlManager.registerTpsPoint(TpsMonitorItem.NAMING_UDP_PUSH_SUCCESS.name());
        this.tpsControlManager.registerTpsPoint(TpsMonitorItem.NAMING_UDP_PUSH_FAIL.name());
    }

    private void registerDistroMonitorPoint() {
        this.tpsControlManager.registerTpsPoint(TpsMonitorItem.NAMING_DISTRO_SYNC.name());
        this.tpsControlManager.registerTpsPoint(TpsMonitorItem.NAMING_DISTRO_SYNC_SUCCESS.name());
        this.tpsControlManager.registerTpsPoint(TpsMonitorItem.NAMING_DISTRO_SYNC_FAIL.name());
        this.tpsControlManager.registerTpsPoint(TpsMonitorItem.NAMING_DISTRO_VERIFY.name());
        this.tpsControlManager.registerTpsPoint(TpsMonitorItem.NAMING_DISTRO_VERIFY_SUCCESS.name());
        this.tpsControlManager.registerTpsPoint(TpsMonitorItem.NAMING_DISTRO_VERIFY_FAIL.name());
    }

    public static NamingTpsMonitor getInstance() {
        return INSTANCE;
    }

    public static void rpcPushSuccess(String clientId, String clientIp) {
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_RPC_PUSH.name(), clientId, clientIp));
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_RPC_PUSH_SUCCESS.name(), clientId, clientIp));
    }

    public static void rpcPushFail(String clientId, String clientIp) {
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_RPC_PUSH.name(), clientId, clientIp));
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_RPC_PUSH_FAIL.name(), clientId, clientIp));
    }

    public static void udpPushSuccess(String clientId, String clientIp) {
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_UDP_PUSH.name(), clientId, clientIp));
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_UDP_PUSH_SUCCESS.name(), clientId, clientIp));
    }

    public static void udpPushFail(String clientId, String clientIp) {
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_UDP_PUSH.name(), clientId, clientIp));
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_UDP_PUSH_FAIL.name(), clientId, clientIp));
    }

    public static void distroSyncSuccess(String clientId, String clientIp) {
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_DISTRO_SYNC.name(), clientId, clientIp));
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_DISTRO_SYNC_SUCCESS.name(), clientId, clientIp));
    }

    public static void distroSyncFail(String clientId, String clientIp) {
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_DISTRO_SYNC.name(), clientId, clientIp));
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_DISTRO_SYNC_FAIL.name(), clientId, clientIp));
    }

    public static void distroVerifySuccess(String clientId, String clientIp) {
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_DISTRO_VERIFY.name(), clientId, clientIp));
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_DISTRO_VERIFY_SUCCESS.name(), clientId, clientIp));
    }

    public static void distroVerifyFail(String clientId, String clientIp) {
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_DISTRO_VERIFY.name(), clientId, clientIp));
        NamingTpsMonitor.INSTANCE.tpsControlManager.check(new TpsCheckRequest(TpsMonitorItem.NAMING_DISTRO_VERIFY_FAIL.name(), clientId, clientIp));
    }
}

