/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.service;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.pojo.Subscriber;
import java.util.List;
import java.util.Map;

public interface ClientOperationService {
    public static final double EPSILON = 1.0E-10;

    public void registerInstance(Service var1, Instance var2, String var3) throws NacosException;

    public void batchRegisterInstance(Service var1, List<Instance> var2, String var3);

    public void deregisterInstance(Service var1, Instance var2, String var3);

    default public void subscribeService(Service service, Subscriber subscriber, String clientId) {
    }

    default public void unsubscribeService(Service service, Subscriber subscriber, String clientId) {
    }

    default public InstancePublishInfo getPublishInfo(Instance instance) {
        InstancePublishInfo result = new InstancePublishInfo(instance.getIp(), instance.getPort());
        Map<String, Object> extendDatum = result.getExtendDatum();
        if (null != instance.getMetadata() && !instance.getMetadata().isEmpty()) {
            extendDatum.putAll(instance.getMetadata());
        }
        if (StringUtils.isNotEmpty((String)instance.getInstanceId())) {
            extendDatum.put("customInstanceId", instance.getInstanceId());
        }
        if (Math.abs(1.0 - instance.getWeight()) >= 1.0E-10) {
            extendDatum.put("publishInstanceWeight", instance.getWeight());
        }
        if (!instance.isEnabled()) {
            extendDatum.put("publishInstanceEnable", instance.isEnabled());
        }
        String clusterName = StringUtils.isBlank((CharSequence)instance.getClusterName()) ? "DEFAULT" : instance.getClusterName();
        result.setHealthy(instance.isHealthy());
        result.setCluster(clusterName);
        return result;
    }
}

