/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.index;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.common.utils.FuzzyGroupKeyPattern;
import com.alibaba.nacos.core.utils.GlobalExecutor;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.event.client.ClientOperationEvent;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.misc.GlobalConfig;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class NamingFuzzyWatchContextService
extends SmartSubscriber {
    private final ConcurrentMap<String, Set<String>> watchedClientsMap = new ConcurrentHashMap<String, Set<String>>();
    private final ConcurrentMap<String, Set<String>> matchedServiceKeysMap = new ConcurrentHashMap<String, Set<String>>();

    @PostConstruct
    public void init() {
        GlobalExecutor.scheduleWithFixDelayByCommon(() -> this.trimFuzzyWatchContext(), (long)30000L);
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    void trimFuzzyWatchContext() {
        try {
            Iterator iterator = this.matchedServiceKeysMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                Set watchedClients = (Set)this.watchedClientsMap.get(next.getKey());
                int serviceKeysCount = ((Set)next.getValue()).size();
                if (watchedClients == null) {
                    Loggers.SRV_LOG.info("[fuzzy-watch] no watchedClients context for pattern {},remove matchedGroupKeys context", next.getKey());
                    iterator.remove();
                    continue;
                }
                if (watchedClients.isEmpty()) {
                    Loggers.SRV_LOG.info("[fuzzy-watch] no client watched pattern {},remove watchedClients context", next.getKey());
                    this.watchedClientsMap.remove(next.getKey());
                    continue;
                }
                if (this.reachToUpLimit(serviceKeysCount)) {
                    Loggers.SRV_LOG.warn("[fuzzy-watch] pattern {} matched serviceKey count is reach to upper limit {}, fuzzy watch notify may be suppressed ", next.getKey(), (Object)((Set)next.getValue()).size());
                    continue;
                }
                if (!this.reachToUpLimit((int)((double)serviceKeysCount * 1.25))) continue;
                Loggers.SRV_LOG.warn("[fuzzy-watch] pattern {} matched serviceKey count has reached to 80% of the upper limit {} ,it may has a risk of notify suppressed in the near further", next.getKey(), (Object)serviceKeysCount);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public List<Class<? extends Event>> subscribeTypes() {
        LinkedList<Class<? extends Event>> result = new LinkedList<Class<? extends Event>>();
        result.add(ClientOperationEvent.ClientReleaseEvent.class);
        return result;
    }

    public void onEvent(Event event) {
        if (event instanceof ClientOperationEvent.ClientReleaseEvent) {
            this.removeFuzzyWatchContext(((ClientOperationEvent.ClientReleaseEvent)event).getClientId());
        }
    }

    public Set<String> getFuzzyWatchedClients(Service service) {
        HashSet<String> matchedClients = new HashSet<String>();
        for (Map.Entry entry : this.watchedClientsMap.entrySet()) {
            if (!FuzzyGroupKeyPattern.matchPattern((String)((String)entry.getKey()), (String)service.getName(), (String)service.getGroup(), (String)service.getNamespace())) continue;
            matchedClients.addAll((Collection)entry.getValue());
        }
        return matchedClients;
    }

    public boolean syncServiceContext(Service changedService, String changedType) {
        boolean needNotify = false;
        if (!changedType.equals("ADD_SERVICE") && !changedType.equals("DELETE_SERVICE")) {
            return false;
        }
        String serviceKey = NamingUtils.getServiceKey((String)changedService.getNamespace(), (String)changedService.getGroup(), (String)changedService.getName());
        Loggers.SRV_LOG.warn("[fuzzy-watch] service change matched,service key {},changed type {} ", (Object)serviceKey, (Object)changedType);
        Iterator iterator = this.matchedServiceKeysMap.entrySet().iterator();
        boolean tryAdd = changedType.equals("ADD_SERVICE");
        boolean tryRemove = changedType.equals("DELETE_SERVICE");
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            if (!FuzzyGroupKeyPattern.matchPattern((String)((String)next.getKey()), (String)changedService.getName(), (String)changedService.getGroup(), (String)changedService.getNamespace())) continue;
            Set matchedServiceKeys = (Set)next.getValue();
            boolean reachToUpLimit = this.reachToUpLimit(matchedServiceKeys.size());
            boolean containsAlready = matchedServiceKeys.contains(serviceKey);
            if (tryAdd && !containsAlready && reachToUpLimit) {
                Loggers.SRV_LOG.warn("[fuzzy-watch] pattern matched service count is over limit , current service will be ignore for pattern {} ,current count is {}", next.getKey(), (Object)matchedServiceKeys.size());
                continue;
            }
            if (tryAdd && !containsAlready && matchedServiceKeys.add(serviceKey)) {
                Loggers.SRV_LOG.info("[fuzzy-watch] pattern {} matched service keys count changed to {}", next.getKey(), (Object)matchedServiceKeys.size());
                needNotify = true;
            }
            if (!tryRemove || !containsAlready || !matchedServiceKeys.remove(serviceKey)) continue;
            Loggers.SRV_LOG.info("[fuzzy-watch]  pattern {} matched service keys count changed to {}", next.getKey(), (Object)matchedServiceKeys.size());
            needNotify = true;
            if (!reachToUpLimit) continue;
            this.makeupMatchedGroupKeys((String)next.getKey());
        }
        return needNotify;
    }

    private boolean reachToUpLimit(int size) {
        return size >= GlobalConfig.getMaxMatchedServiceCount();
    }

    public boolean reachToUpLimit(String groupKeyPattern) {
        Set strings = (Set)this.matchedServiceKeysMap.get(groupKeyPattern);
        return strings != null && this.reachToUpLimit(strings.size());
    }

    public void makeupMatchedGroupKeys(String groupKeyPattern) {
        Set matchedGroupKeys = (Set)this.matchedServiceKeysMap.get(groupKeyPattern);
        if (matchedGroupKeys == null || this.reachToUpLimit(matchedGroupKeys.size())) {
            return;
        }
        Set<Service> namespaceServices = ServiceManager.getInstance().getSingletons(FuzzyGroupKeyPattern.getNamespaceFromPattern((String)groupKeyPattern));
        for (Service service : namespaceServices) {
            String serviceKey = NamingUtils.getServiceKey((String)service.getNamespace(), (String)service.getGroup(), (String)service.getName());
            if (!FuzzyGroupKeyPattern.matchPattern((String)groupKeyPattern, (String)service.getName(), (String)service.getGroup(), (String)service.getNamespace()) || matchedGroupKeys.contains(serviceKey) || !matchedGroupKeys.add(serviceKey)) continue;
            Loggers.SRV_LOG.info("[fuzzy-watch] pattern {} makeup service key {}", (Object)groupKeyPattern, (Object)serviceKey);
            if (!this.reachToUpLimit(matchedGroupKeys.size())) continue;
            Loggers.SRV_LOG.warn("[fuzzy-watch] pattern {} matched service count reach to up limit ,makeup group keys skip.", (Object)groupKeyPattern);
            return;
        }
    }

    public void syncFuzzyWatcherContext(String groupKeyPattern, String clientId) throws NacosException {
        this.watchedClientsMap.computeIfAbsent(groupKeyPattern, key -> new ConcurrentHashSet());
        this.initWatchMatchService(groupKeyPattern);
        ((Set)this.watchedClientsMap.get(groupKeyPattern)).add(clientId);
    }

    public Set<String> matchServiceKeys(String groupKeyPattern) {
        Set stringSet = (Set)this.matchedServiceKeysMap.get(groupKeyPattern);
        return stringSet == null ? new HashSet<String>() : new HashSet(stringSet);
    }

    private void removeFuzzyWatchContext(String clientId) {
        for (Map.Entry next : this.watchedClientsMap.entrySet()) {
            ((Set)next.getValue()).remove(clientId);
        }
    }

    public void removeFuzzyWatchContext(String groupKeyPattern, String clientId) {
        if (this.watchedClientsMap.containsKey(groupKeyPattern)) {
            ((Set)this.watchedClientsMap.get(groupKeyPattern)).remove(clientId);
        }
    }

    public Set<String> initWatchMatchService(String completedPattern) throws NacosException {
        if (!this.matchedServiceKeysMap.containsKey(completedPattern)) {
            if (this.matchedServiceKeysMap.size() >= GlobalConfig.getMaxPatternCount()) {
                Loggers.SRV_LOG.warn("FUZZY_WATCH: fuzzy watch pattern count is over limit ,pattern {} init fail,current count is {}", (Object)completedPattern, (Object)this.matchedServiceKeysMap.size());
                throw new NacosException(ErrorCode.FUZZY_WATCH_PATTERN_OVER_LIMIT.getCode().intValue(), ErrorCode.FUZZY_WATCH_PATTERN_OVER_LIMIT.getMsg());
            }
            long matchBeginTime = System.currentTimeMillis();
            Set<Service> namespaceServices = ServiceManager.getInstance().getSingletons(FuzzyGroupKeyPattern.getNamespaceFromPattern((String)completedPattern));
            Set matchedServices = this.matchedServiceKeysMap.computeIfAbsent(completedPattern, k -> new HashSet());
            boolean overMatchCount = false;
            for (Service service : namespaceServices) {
                if (!FuzzyGroupKeyPattern.matchPattern((String)completedPattern, (String)service.getName(), (String)service.getGroup(), (String)service.getNamespace())) continue;
                if (matchedServices.size() >= GlobalConfig.getMaxMatchedServiceCount()) {
                    Loggers.SRV_LOG.warn("[fuzzy-watch] pattern matched service count is over limit , other services will stop notify for pattern {} ,current count is {}", (Object)completedPattern, (Object)matchedServices.size());
                    overMatchCount = true;
                    break;
                }
                matchedServices.add(NamingUtils.getServiceKey((String)service.getNamespace(), (String)service.getGroup(), (String)service.getName()));
            }
            this.matchedServiceKeysMap.putIfAbsent(completedPattern, matchedServices);
            Loggers.SRV_LOG.info("FUZZY_WATCH: pattern {} match {} services, overMatchCount={},cost {}ms", new Object[]{completedPattern, matchedServices.size(), overMatchCount, System.currentTimeMillis() - matchBeginTime});
        }
        return new HashSet<String>((Collection)this.matchedServiceKeysMap.get(completedPattern));
    }
}

