/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClientPublisherInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClientServiceInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClientSubscriberInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClientSummaryInfo;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.ConnectionMeta;
import com.alibaba.nacos.naming.core.ClientService;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.impl.ConnectionBasedClient;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.index.ClientServiceIndexesManager;
import com.alibaba.nacos.naming.core.v2.pojo.BatchInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ClientServiceImpl
implements ClientService {
    @Resource
    private ClientManager clientManager;
    @Resource
    private ConnectionManager connectionManager;
    @Resource
    private ClientServiceIndexesManager clientServiceIndexesManager;
    @Resource
    private DistroMapper distroMapper;

    @Override
    public List<String> getClientList() {
        return new ArrayList<String>(this.clientManager.allClientId());
    }

    @Override
    public ClientSummaryInfo getClientDetail(String clientId) throws NacosApiException {
        Client client = this.clientManager.getClient(clientId);
        if (null == client) {
            throw new NacosApiException(404, ErrorCode.RESOURCE_NOT_FOUND, String.format("Client id %s not exist.", clientId));
        }
        ClientSummaryInfo result = new ClientSummaryInfo();
        result.setClientId(client.getClientId());
        result.setEphemeral(client.isEphemeral());
        result.setLastUpdatedTime(client.getLastUpdatedTime());
        result.setClientType("ipPort");
        if (client instanceof ConnectionBasedClient) {
            result.setClientType("connection");
            Connection connection = this.connectionManager.getConnection(clientId);
            ConnectionMeta connectionMetaInfo = connection.getMetaInfo();
            result.setConnectType(connectionMetaInfo.getConnectType());
            result.setAppName(connectionMetaInfo.getAppName());
            result.setVersion(connectionMetaInfo.getVersion());
            result.setClientIp(connectionMetaInfo.getClientIp());
            result.setClientPort(connectionMetaInfo.getRemotePort());
        }
        return result;
    }

    @Override
    public List<ObjectNode> getPublishedServiceListAdapt(String clientId) {
        Client client = this.clientManager.getClient(clientId);
        Collection<Service> allPublishedService = client.getAllPublishedService();
        ArrayList<ObjectNode> res = new ArrayList<ObjectNode>();
        for (Service service : allPublishedService) {
            InstancePublishInfo instancePublishInfo = client.getInstancePublishInfo(service);
            if (instancePublishInfo instanceof BatchInstancePublishInfo) {
                List<InstancePublishInfo> instancePublishInfos = ((BatchInstancePublishInfo)instancePublishInfo).getInstancePublishInfos();
                for (InstancePublishInfo publishInfo : instancePublishInfos) {
                    res.add(this.wrapSingleInstanceNode(publishInfo, service));
                }
                continue;
            }
            res.add(this.wrapSingleInstanceNode(instancePublishInfo, service));
        }
        return res;
    }

    @Override
    public List<ClientServiceInfo> getPublishedServiceList(String clientId) {
        Client client = this.clientManager.getClient(clientId);
        Collection<Service> allPublishedService = client.getAllPublishedService();
        LinkedList<ClientServiceInfo> result = new LinkedList<ClientServiceInfo>();
        for (Service each : allPublishedService) {
            InstancePublishInfo instancePublishInfo = client.getInstancePublishInfo(each);
            if (instancePublishInfo instanceof BatchInstancePublishInfo) {
                for (InstancePublishInfo eachPub : ((BatchInstancePublishInfo)instancePublishInfo).getInstancePublishInfos()) {
                    result.add(this.buildClientServiceInfo(each, eachPub, null));
                }
                continue;
            }
            result.add(this.buildClientServiceInfo(each, instancePublishInfo, null));
        }
        return result;
    }

    private ObjectNode wrapSingleInstanceNode(InstancePublishInfo instancePublishInfo, Service service) {
        ObjectNode item = JacksonUtils.createEmptyJsonNode();
        item.put("namespace", service.getNamespace());
        item.put("group", service.getGroup());
        item.put("serviceName", service.getName());
        item.set("registeredInstance", (JsonNode)this.wrapSingleInstance(instancePublishInfo));
        return item;
    }

    private ObjectNode wrapSingleInstance(InstancePublishInfo instancePublishInfo) {
        ObjectNode instanceInfo = JacksonUtils.createEmptyJsonNode();
        instanceInfo.put("ip", instancePublishInfo.getIp());
        instanceInfo.put("port", instancePublishInfo.getPort());
        instanceInfo.put("cluster", instancePublishInfo.getCluster());
        return instanceInfo;
    }

    @Override
    public List<ObjectNode> getSubscribeServiceListAdapt(String clientId) {
        Client client = this.clientManager.getClient(clientId);
        Collection<Service> allSubscribeService = client.getAllSubscribeService();
        ArrayList<ObjectNode> res = new ArrayList<ObjectNode>();
        for (Service service : allSubscribeService) {
            ObjectNode item = JacksonUtils.createEmptyJsonNode();
            item.put("namespace", service.getNamespace());
            item.put("group", service.getGroup());
            item.put("serviceName", service.getName());
            Subscriber subscriber = client.getSubscriber(service);
            ObjectNode subscriberInfo = JacksonUtils.createEmptyJsonNode();
            subscriberInfo.put("app", subscriber.getApp());
            subscriberInfo.put("agent", subscriber.getAgent());
            subscriberInfo.put("addr", subscriber.getAddrStr());
            item.set("subscriberInfo", (JsonNode)subscriberInfo);
            res.add(item);
        }
        return res;
    }

    @Override
    public List<ClientServiceInfo> getSubscribeServiceList(String clientId) {
        Client client = this.clientManager.getClient(clientId);
        Collection<Service> allSubscribeService = client.getAllSubscribeService();
        LinkedList<ClientServiceInfo> result = new LinkedList<ClientServiceInfo>();
        for (Service each : allSubscribeService) {
            Subscriber subscriber = client.getSubscriber(each);
            result.add(this.buildClientServiceInfo(each, null, subscriber));
        }
        return result;
    }

    @Override
    public List<ObjectNode> getPublishedClientList(String namespaceId, String groupName, String serviceName, boolean ephemeral, String ip, Integer port) {
        Service service = Service.newService(namespaceId, groupName, serviceName, ephemeral);
        Collection<String> allClientsRegisteredService = this.clientServiceIndexesManager.getAllClientsRegisteredService(service);
        ArrayList<ObjectNode> res = new ArrayList<ObjectNode>();
        for (String clientId : allClientsRegisteredService) {
            Client client = this.clientManager.getClient(clientId);
            InstancePublishInfo instancePublishInfo = client.getInstancePublishInfo(service);
            if (instancePublishInfo instanceof BatchInstancePublishInfo) {
                List<InstancePublishInfo> list = ((BatchInstancePublishInfo)instancePublishInfo).getInstancePublishInfos();
                for (InstancePublishInfo info : list) {
                    if (!Objects.equals(info.getIp(), ip) || !Objects.equals(port, info.getPort())) continue;
                    res.add(this.wrapSingleInstance(info).put("clientId", clientId));
                }
                continue;
            }
            if (!Objects.equals(instancePublishInfo.getIp(), ip) || !Objects.equals(port, instancePublishInfo.getPort())) continue;
            res.add(this.wrapSingleInstance(instancePublishInfo).put("clientId", clientId));
        }
        return res;
    }

    @Override
    public List<ClientPublisherInfo> getPublishedClientList(String namespaceId, String groupName, String serviceName, String ip, Integer port) {
        Service service = Service.newService(namespaceId, groupName, serviceName);
        Collection<String> allClientsRegisteredService = this.clientServiceIndexesManager.getAllClientsRegisteredService(service);
        LinkedList<ClientPublisherInfo> result = new LinkedList<ClientPublisherInfo>();
        for (String clientId : allClientsRegisteredService) {
            Client client = this.clientManager.getClient(clientId);
            InstancePublishInfo instancePublishInfo = client.getInstancePublishInfo(service);
            if (instancePublishInfo instanceof BatchInstancePublishInfo) {
                for (InstancePublishInfo info : ((BatchInstancePublishInfo)instancePublishInfo).getInstancePublishInfos()) {
                    this.filterInstancePublishInfo(info, ip, port, clientId).ifPresent(result::add);
                }
                continue;
            }
            this.filterInstancePublishInfo(instancePublishInfo, ip, port, clientId).ifPresent(result::add);
        }
        return result;
    }

    private Optional<ClientPublisherInfo> filterInstancePublishInfo(InstancePublishInfo instancePublishInfo, String expectedIp, Integer expectedPort, String clientId) {
        boolean portMatch;
        boolean ipMatch = Objects.isNull(expectedIp) || Objects.equals(expectedIp, instancePublishInfo.getIp());
        boolean bl = portMatch = Objects.isNull(expectedPort) || Objects.equals(expectedPort, instancePublishInfo.getPort());
        if (!ipMatch || !portMatch) {
            return Optional.empty();
        }
        ClientPublisherInfo clientPublisherInfo = this.buildClientPublisherInfo(instancePublishInfo);
        clientPublisherInfo.setClientId(clientId);
        return Optional.of(clientPublisherInfo);
    }

    @Override
    public List<ObjectNode> getSubscribeClientList(String namespaceId, String groupName, String serviceName, boolean ephemeral, String ip, Integer port) {
        Service service = Service.newService(namespaceId, groupName, serviceName, ephemeral);
        Collection<String> allClientsSubscribeService = this.clientServiceIndexesManager.getAllClientsSubscribeService(service);
        ArrayList<ObjectNode> res = new ArrayList<ObjectNode>();
        for (String clientId : allClientsSubscribeService) {
            boolean portMatch;
            Client client = this.clientManager.getClient(clientId);
            Subscriber subscriber = client.getSubscriber(service);
            boolean ipMatch = Objects.isNull(ip) || Objects.equals(ip, subscriber.getIp());
            boolean bl = portMatch = Objects.isNull(port) || Objects.equals(port, subscriber.getPort());
            if (!ipMatch || !portMatch) continue;
            ObjectNode item = JacksonUtils.createEmptyJsonNode();
            item.put("clientId", clientId);
            item.put("ip", subscriber.getIp());
            item.put("port", subscriber.getPort());
            res.add(item);
        }
        return res;
    }

    @Override
    public List<ClientSubscriberInfo> getSubscribeClientList(String namespaceId, String groupName, String serviceName, String ip, Integer port) {
        Service service = Service.newService(namespaceId, groupName, serviceName);
        Collection<String> allClientsSubscribeService = this.clientServiceIndexesManager.getAllClientsSubscribeService(service);
        LinkedList<ClientSubscriberInfo> result = new LinkedList<ClientSubscriberInfo>();
        for (String clientId : allClientsSubscribeService) {
            boolean portMatch;
            Client client = this.clientManager.getClient(clientId);
            Subscriber subscriber = client.getSubscriber(service);
            boolean ipMatch = Objects.isNull(ip) || Objects.equals(ip, subscriber.getIp());
            boolean bl = portMatch = Objects.isNull(port) || Objects.equals(port, subscriber.getPort());
            if (!ipMatch || !portMatch) continue;
            ClientSubscriberInfo item = new ClientSubscriberInfo();
            item.setClientId(clientId);
            item.setAddress(subscriber.getAddrStr());
            item.setAgent(subscriber.getAgent());
            item.setAppName(subscriber.getApp());
            result.add(item);
        }
        return result;
    }

    @Override
    public ObjectNode getResponsibleServer4Client(String ip, String port) {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        String tag = ip + ":" + port;
        result.put("responsibleServer", this.distroMapper.mapSrv(tag));
        return result;
    }

    private ClientServiceInfo buildClientServiceInfo(Service service, InstancePublishInfo instancePublishInfo, Subscriber subscriber) {
        ClientServiceInfo result = new ClientServiceInfo();
        result.setNamespaceId(service.getNamespace());
        result.setGroupName(service.getGroup());
        result.setServiceName(service.getName());
        if (null != instancePublishInfo) {
            result.setPublisherInfo(this.buildClientPublisherInfo(instancePublishInfo));
        }
        if (null != subscriber) {
            result.setSubscriberInfo(this.buildClientSubscriberInfo(subscriber));
        }
        return result;
    }

    private ClientPublisherInfo buildClientPublisherInfo(InstancePublishInfo instancePublishInfo) {
        ClientPublisherInfo result = new ClientPublisherInfo();
        result.setIp(instancePublishInfo.getIp());
        result.setPort(instancePublishInfo.getPort());
        result.setClusterName(instancePublishInfo.getCluster());
        return result;
    }

    private ClientSubscriberInfo buildClientSubscriberInfo(Subscriber subscriber) {
        ClientSubscriberInfo result = new ClientSubscriberInfo();
        result.setAddress(subscriber.getAddrStr());
        result.setAgent(subscriber.getAgent());
        result.setAppName(subscriber.getApp());
        return result;
    }
}

