/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.web;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.code.ControllerMethodsCache;
import com.alibaba.nacos.core.utils.ReuseHttpServletRequest;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.misc.HttpClient;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.web.CanDistro;
import com.alibaba.nacos.naming.web.DistroTagGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class DistroFilter
implements Filter {
    private static final int PROXY_CONNECT_TIMEOUT = 2000;
    private static final int PROXY_READ_TIMEOUT = 2000;
    @Autowired
    private DistroMapper distroMapper;
    @Autowired
    private ControllerMethodsCache controllerMethodsCache;
    @Autowired
    private DistroTagGenerator distroTagGenerator;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        ReuseHttpServletRequest req = new ReuseHttpServletRequest((HttpServletRequest)servletRequest);
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        String urlString = req.getRequestURI();
        if (StringUtils.isNotBlank((String)req.getQueryString())) {
            urlString = urlString + "?" + req.getQueryString();
        }
        try {
            Method method = this.controllerMethodsCache.getMethod((HttpServletRequest)req);
            String path = new URI(req.getRequestURI()).getPath();
            if (method == null) {
                throw new NoSuchMethodException(req.getMethod() + " " + path);
            }
            if (!method.isAnnotationPresent(CanDistro.class)) {
                filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            String distroTag = this.distroTagGenerator.getResponsibleTag(req);
            if (this.distroMapper.responsible(distroTag)) {
                filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            String userAgent = req.getHeader("User-Agent");
            if (StringUtils.isNotBlank((String)userAgent) && userAgent.contains("Nacos-Server")) {
                Loggers.SRV_LOG.error("receive invalid redirect request from peer {}", (Object)req.getRemoteAddr());
                resp.sendError(400, "receive invalid redirect request from peer " + req.getRemoteAddr());
                return;
            }
            String targetServer = this.distroMapper.mapSrv(distroTag);
            ArrayList<String> headerList = new ArrayList<String>(16);
            Enumeration headers = req.getHeaderNames();
            while (headers.hasMoreElements()) {
                String headerName = (String)headers.nextElement();
                headerList.add(headerName);
                headerList.add(req.getHeader(headerName));
            }
            String body = IoUtils.toString((InputStream)req.getInputStream(), (String)StandardCharsets.UTF_8.name());
            Map<String, String> paramsValue = HttpClient.translateParameterMap(req.getParameterMap());
            RestResult<String> result = HttpClient.request("http://" + targetServer + req.getRequestURI(), headerList, paramsValue, body, 2000, 2000, StandardCharsets.UTF_8.name(), req.getMethod());
            String data = result.ok() ? (String)result.getData() : result.getMessage();
            try {
                WebUtils.response((HttpServletResponse)resp, (String)data, (int)result.getCode());
            }
            catch (Exception ignore) {
                Loggers.SRV_LOG.warn("[DISTRO-FILTER] request failed: " + this.distroMapper.mapSrv(distroTag) + urlString);
            }
        }
        catch (AccessControlException e) {
            resp.sendError(403, "access denied: " + ExceptionUtil.getAllExceptionMsg((Throwable)e));
        }
        catch (NoSuchMethodException e) {
            resp.sendError(501, "no such api:" + req.getMethod() + ":" + req.getRequestURI());
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("[DISTRO-FILTER] Server failed: ", (Throwable)e);
            resp.sendError(500, "Server failed, " + ExceptionUtil.getAllExceptionMsg((Throwable)e));
        }
    }

    public void destroy() {
    }
}

