/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckType;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.HealthOperator;
import com.alibaba.nacos.naming.core.HealthOperatorV2Impl;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import com.alibaba.nacos.naming.paramcheck.NamingDefaultHttpParamExtractor;
import com.alibaba.nacos.naming.web.CanDistro;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="namingHealthController")
@RequestMapping(value={"/v1/ns/health"})
@ExtractorManager.Extractor(httpExtractor=NamingDefaultHttpParamExtractor.class)
public class HealthController {
    @Autowired
    private HealthOperatorV2Impl healthOperatorV2;

    @RequestMapping(value={"/server"})
    public ResponseEntity server() {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("msg", "Hello! I am Nacos-Naming and healthy! total services: " + MetricsMonitor.getDomCountMonitor() + ", local port:" + EnvUtil.getPort());
        return ResponseEntity.ok((Object)result);
    }

    @CanDistro
    @PutMapping(value={"", "/instance"})
    @Secured(action=ActionTypes.WRITE)
    public ResponseEntity update(HttpServletRequest request) throws NacosException {
        String healthyString = WebUtils.optional((HttpServletRequest)request, (String)"healthy", (String)"");
        if (StringUtils.isBlank((CharSequence)healthyString)) {
            healthyString = WebUtils.optional((HttpServletRequest)request, (String)"valid", (String)"");
        }
        if (StringUtils.isBlank((CharSequence)healthyString)) {
            throw new IllegalArgumentException("Param 'healthy' is required.");
        }
        boolean health = ConvertUtils.toBoolean((String)healthyString);
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String clusterName = WebUtils.optional((HttpServletRequest)request, (String)"clusterName", (String)"DEFAULT");
        String ip = WebUtils.required((HttpServletRequest)request, (String)"ip");
        int port = Integer.parseInt(WebUtils.required((HttpServletRequest)request, (String)"port"));
        this.getHealthOperator().updateHealthStatusForPersistentInstance(namespaceId, serviceName, clusterName, ip, port, health);
        return ResponseEntity.ok((Object)"ok");
    }

    @GetMapping(value={"/checkers"})
    public ResponseEntity checkers() {
        List classes = HealthCheckType.getLoadedHealthCheckerClasses();
        HashMap<String, AbstractHealthChecker> checkerMap = new HashMap<String, AbstractHealthChecker>(8);
        for (Class clazz : classes) {
            try {
                AbstractHealthChecker checker = (AbstractHealthChecker)clazz.newInstance();
                checkerMap.put(checker.getType(), checker);
            }
            catch (IllegalAccessException | InstantiationException e) {
                Loggers.EVT_LOG.error("checkers error ", (Throwable)e);
            }
        }
        return ResponseEntity.ok(checkerMap);
    }

    private HealthOperator getHealthOperator() {
        return this.healthOperatorV2;
    }
}

