/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.ai;

import com.alibaba.nacos.api.ai.model.a2a.AgentCard;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardDetailInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardVersionInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentVersionDetail;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.maintainer.client.ai.AiMaintainerService;
import com.alibaba.nacos.maintainer.client.model.HttpRequest;
import com.alibaba.nacos.maintainer.client.remote.ClientHttpProxy;
import com.alibaba.nacos.maintainer.client.utils.ParamUtil;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class NacosAiMaintainerServiceImpl
implements AiMaintainerService {
    public static final String SEARCH_BLUR = "blur";
    public static final String SEARCH_ACCURATE = "accurate";
    private final ClientHttpProxy clientHttpProxy;

    public NacosAiMaintainerServiceImpl(Properties properties) throws NacosException {
        this.clientHttpProxy = new ClientHttpProxy(properties);
        ParamUtil.initSerialization();
    }

    @Override
    public Page<McpServerBasicInfo> listMcpServer(String namespaceId, String mcpName, int pageNo, int pageSize) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        params.put("search", SEARCH_ACCURATE);
        params.put("mcpName", mcpName);
        params.put("namespaceId", namespaceId);
        RequestResource resource = this.buildRequestResource(namespaceId, mcpName);
        return this.getMcpServerBasicInfoPage(params, resource);
    }

    @Override
    public Page<McpServerBasicInfo> searchMcpServer(String namespaceId, String mcpName, int pageNo, int pageSize) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        params.put("search", SEARCH_BLUR);
        params.put("mcpName", mcpName);
        params.put("namespaceId", namespaceId);
        RequestResource resource = this.buildRequestResource(namespaceId, mcpName);
        return this.getMcpServerBasicInfoPage(params, resource);
    }

    private Page<McpServerBasicInfo> getMcpServerBasicInfoPage(Map<String, String> params, RequestResource resource) throws NacosException {
        HttpRequest httpRequest = this.buildHttpRequestBuilder(resource).setHttpMethod("GET").setPath("/v3/admin/ai/mcp/list").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<Page<McpServerBasicInfo>>>(){});
        return (Page)result.getData();
    }

    @Override
    public McpServerDetailInfo getMcpServerDetail(String namespaceId, String mcpName, String mcpId, String version) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("mcpName", mcpName);
        params.put("mcpId", mcpId);
        params.put("version", version);
        params.put("namespaceId", namespaceId);
        RequestResource resource = this.buildRequestResource(namespaceId, mcpName);
        HttpRequest httpRequest = this.buildHttpRequestBuilder(resource).setHttpMethod("GET").setPath("/v3/admin/ai/mcp").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<McpServerDetailInfo>>(){});
        return (McpServerDetailInfo)result.getData();
    }

    @Override
    public String createMcpServer(String namespaceId, String mcpName, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        Map<String, String> params = this.buildFullParameters(serverSpec, toolSpec, endpointSpec);
        params.put("namespaceId", namespaceId);
        RequestResource resource = this.buildRequestResource(namespaceId, mcpName);
        HttpRequest httpRequest = this.buildHttpRequestBuilder(resource).setHttpMethod("POST").setPath("/v3/admin/ai/mcp").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public boolean updateMcpServer(String namespaceId, String mcpName, boolean isLatest, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec, boolean overrideExisting) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        Map<String, String> params = this.buildFullParameters(serverSpec, toolSpec, endpointSpec);
        params.put("latest", String.valueOf(isLatest));
        params.put("namespaceId", namespaceId);
        params.put("overrideExisting", String.valueOf(overrideExisting));
        RequestResource resource = this.buildRequestResource(namespaceId, mcpName);
        HttpRequest httpRequest = this.buildHttpRequestBuilder(resource).setHttpMethod("PUT").setPath("/v3/admin/ai/mcp").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return ErrorCode.SUCCESS.getCode().equals(result.getCode());
    }

    private Map<String, String> buildFullParameters(McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("mcpName", serverSpec.getName());
        params.put("serverSpecification", JacksonUtils.toJson((Object)serverSpec));
        if (null != toolSpec) {
            params.put("toolSpecification", JacksonUtils.toJson((Object)toolSpec));
        }
        if (null != endpointSpec) {
            params.put("endpointSpecification", JacksonUtils.toJson((Object)endpointSpec));
        }
        return params;
    }

    @Override
    public boolean deleteMcpServer(String namespaceId, String mcpName, String mcpId, String version) throws NacosException {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = "public";
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("mcpName", mcpName);
        params.put("mcpId", mcpId);
        params.put("version", version);
        params.put("namespaceId", namespaceId);
        RequestResource resource = this.buildRequestResource(namespaceId, mcpName);
        HttpRequest httpRequest = this.buildHttpRequestBuilder(resource).setHttpMethod("DELETE").setPath("/v3/admin/ai/mcp").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return ErrorCode.SUCCESS.getCode().equals(result.getCode());
    }

    private RequestResource buildRequestResource(String namespaceId, String resourceName) {
        RequestResource.Builder builder = RequestResource.aiBuilder();
        builder.setNamespace(namespaceId);
        builder.setGroup("DEFAULT_GROUP");
        builder.setResource(null == resourceName ? "" : resourceName);
        return builder.build();
    }

    private HttpRequest.Builder buildHttpRequestBuilder(RequestResource resource) {
        return new HttpRequest.Builder().setResource(resource);
    }

    @Override
    public boolean registerAgent(AgentCard agentCard, String namespaceId, String registrationType) throws NacosException {
        RequestResource resource = this.buildRequestResource(namespaceId, agentCard.getName());
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("agentCard", JacksonUtils.toJson((Object)agentCard));
        params.put("namespaceId", namespaceId);
        params.put("agentName", agentCard.getName());
        params.put("registrationType", registrationType);
        HttpRequest request = this.buildHttpRequestBuilder(resource).setHttpMethod("POST").setParamValue(params).setPath("/v3/admin/ai/a2a").build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(request);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return ErrorCode.SUCCESS.getCode().equals(result.getCode());
    }

    @Override
    public AgentCardDetailInfo getAgentCard(String agentName, String namespaceId, String registrationType) throws NacosException {
        RequestResource resource = this.buildRequestResource(namespaceId, agentName);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("agentName", agentName);
        params.put("namespaceId", namespaceId);
        params.put("registrationType", registrationType);
        HttpRequest request = this.buildHttpRequestBuilder(resource).setHttpMethod("GET").setParamValue(params).setPath("/v3/admin/ai/a2a").build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(request);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<AgentCardDetailInfo>>(){});
        return (AgentCardDetailInfo)result.getData();
    }

    @Override
    public boolean updateAgentCard(AgentCard agentCard, String namespaceId, boolean setAsLatest, String registrationType) throws NacosException {
        RequestResource resource = this.buildRequestResource(namespaceId, agentCard.getName());
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("agentCard", JacksonUtils.toJson((Object)agentCard));
        params.put("namespaceId", namespaceId);
        params.put("agentName", agentCard.getName());
        params.put("setAsLatest", String.valueOf(setAsLatest));
        params.put("registrationType", registrationType);
        HttpRequest request = this.buildHttpRequestBuilder(resource).setHttpMethod("PUT").setParamValue(params).setPath("/v3/admin/ai/a2a").build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(request);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return ErrorCode.SUCCESS.getCode().equals(result.getCode());
    }

    @Override
    public boolean deleteAgent(String agentName, String namespaceId, String version) throws NacosException {
        RequestResource resource = this.buildRequestResource(namespaceId, agentName);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("agentName", agentName);
        params.put("namespaceId", namespaceId);
        params.put("version", version);
        HttpRequest request = this.buildHttpRequestBuilder(resource).setHttpMethod("DELETE").setParamValue(params).setPath("/v3/admin/ai/a2a").build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(request);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return ErrorCode.SUCCESS.getCode().equals(result.getCode());
    }

    @Override
    public List<AgentVersionDetail> listAllVersionOfAgent(String agentName, String namespaceId) throws NacosException {
        RequestResource resource = this.buildRequestResource(namespaceId, agentName);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("agentName", agentName);
        params.put("namespaceId", namespaceId);
        HttpRequest request = this.buildHttpRequestBuilder(resource).setHttpMethod("GET").setParamValue(params).setPath("/v3/admin/ai/a2a/version/list").build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(request);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<List<AgentVersionDetail>>>(){});
        return (List)result.getData();
    }

    @Override
    public Page<AgentCardVersionInfo> searchAgentCardsByName(String namespaceId, String agentNamePattern, int pageNo, int pageSize) throws NacosException {
        return this.listOrSearchAgentCardsByName(namespaceId, agentNamePattern, pageNo, pageSize, true);
    }

    @Override
    public Page<AgentCardVersionInfo> listAgentCards(String namespaceId, String agentName, int pageNo, int pageSize) throws NacosException {
        return this.listOrSearchAgentCardsByName(namespaceId, agentName, pageNo, pageSize, false);
    }

    private Page<AgentCardVersionInfo> listOrSearchAgentCardsByName(String namespaceId, String agentName, int pageNo, int pageSize, boolean isBlur) throws NacosException {
        RequestResource resource = this.buildRequestResource(namespaceId, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("agentName", agentName);
        params.put("namespaceId", namespaceId);
        params.put("search", isBlur ? SEARCH_BLUR : SEARCH_ACCURATE);
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        HttpRequest request = this.buildHttpRequestBuilder(resource).setHttpMethod("GET").setParamValue(params).setPath("/v3/admin/ai/a2a/list").build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(request);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<Page<AgentCardVersionInfo>>>(){});
        return (Page)result.getData();
    }
}

