/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.config;

import com.alibaba.nacos.api.config.model.ConfigBasicInfo;
import com.alibaba.nacos.api.config.model.ConfigCloneInfo;
import com.alibaba.nacos.api.config.model.ConfigDetailInfo;
import com.alibaba.nacos.api.config.model.ConfigGrayInfo;
import com.alibaba.nacos.api.config.model.ConfigHistoryBasicInfo;
import com.alibaba.nacos.api.config.model.ConfigHistoryDetailInfo;
import com.alibaba.nacos.api.config.model.ConfigListenerInfo;
import com.alibaba.nacos.api.config.model.SameConfigPolicy;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.maintainer.client.config.ConfigMaintainerService;
import com.alibaba.nacos.maintainer.client.core.AbstractCoreMaintainerService;
import com.alibaba.nacos.maintainer.client.model.HttpRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class NacosConfigMaintainerServiceImpl
extends AbstractCoreMaintainerService
implements ConfigMaintainerService {
    public NacosConfigMaintainerServiceImpl(Properties properties) throws NacosException {
        super(properties);
    }

    @Override
    public ConfigDetailInfo getConfig(String dataId, String groupName, String namespaceId) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("dataId", dataId);
        params.put("groupName", groupName);
        params.put("namespaceId", namespaceId);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/cs/config").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<ConfigDetailInfo>>(){});
        return (ConfigDetailInfo)result.getData();
    }

    @Override
    public boolean publishConfig(String dataId, String groupName, String namespaceId, String content, String appName, String srcUser, String configTags, String desc, String type) throws NacosException {
        return this.doPublishConfig(dataId, groupName, namespaceId, content, appName, srcUser, configTags, desc, type, null);
    }

    @Override
    public boolean publishBetaConfig(String dataId, String groupName, String namespaceId, String content, String appName, String srcUser, String configTags, String desc, String type, String betaIps) throws NacosException {
        if (StringUtils.isBlank((CharSequence)betaIps)) {
            throw new NacosException(400, "betaIps is empty, not publish beta configuration, please use `publishConfig` directly");
        }
        return this.doPublishConfig(dataId, groupName, namespaceId, content, appName, srcUser, configTags, desc, type, betaIps);
    }

    private boolean doPublishConfig(String dataId, String groupName, String namespaceId, String content, String appName, String srcUser, String configTags, String desc, String type, String betaIps) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("dataId", dataId);
        params.put("groupName", groupName);
        params.put("namespaceId", namespaceId);
        params.put("content", content);
        params.put("appName", appName);
        params.put("srcUser", srcUser);
        params.put("configTags", configTags);
        params.put("desc", desc);
        params.put("type", type);
        HttpRequest.Builder builder = new HttpRequest.Builder().setHttpMethod("POST").setPath("/v3/admin/cs/config").setParamValue(params);
        if (StringUtils.isNotBlank((String)betaIps)) {
            Map<String, String> headers = Collections.singletonMap("betaIps", betaIps);
            builder.addHeader(headers);
        }
        HttpRequest httpRequest = builder.build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Boolean>>(){});
        return (Boolean)result.getData();
    }

    @Override
    public boolean deleteConfig(String dataId, String groupName, String namespaceId) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("dataId", dataId);
        params.put("groupName", groupName);
        params.put("namespaceId", namespaceId);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("DELETE").setPath("/v3/admin/cs/config").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Boolean>>(){});
        return (Boolean)result.getData();
    }

    @Override
    public boolean deleteConfigs(List<Long> ids) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        StringBuilder idStr = new StringBuilder();
        for (Long id : ids) {
            if (idStr.length() > 0) {
                idStr.append(",");
            }
            idStr.append(id);
        }
        params.put("ids", idStr.toString());
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("DELETE").setPath("/v3/admin/cs/config/batch").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Boolean>>(){});
        return (Boolean)result.getData();
    }

    @Override
    public Page<ConfigBasicInfo> searchConfigByDetails(String dataId, String groupName, String namespaceId, String search, String configDetail, String type, String configTags, String appName, int pageNo, int pageSize) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("dataId", dataId);
        params.put("groupName", groupName);
        params.put("namespaceId", namespaceId);
        params.put("search", search);
        params.put("configDetail", configDetail);
        params.put("type", type);
        params.put("configTags", configTags);
        params.put("appName", appName);
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/cs/config/list").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Page<ConfigBasicInfo>>>(){});
        return (Page)result.getData();
    }

    @Override
    public ConfigListenerInfo getListeners(String dataId, String groupName, String namespaceId, boolean aggregation) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("dataId", dataId);
        params.put("groupName", groupName);
        params.put("namespaceId", namespaceId);
        params.put("aggregation", String.valueOf(aggregation));
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/cs/config/listener").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<ConfigListenerInfo>>(){});
        return (ConfigListenerInfo)result.getData();
    }

    @Override
    public boolean stopBeta(String dataId, String groupName, String namespaceId) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("dataId", dataId);
        params.put("groupName", groupName);
        params.put("namespaceId", namespaceId);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("DELETE").setPath("/v3/admin/cs/config/beta").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Boolean>>(){});
        return (Boolean)result.getData();
    }

    @Override
    public ConfigGrayInfo queryBeta(String dataId, String groupName, String namespaceId) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("dataId", dataId);
        params.put("groupName", groupName);
        params.put("namespaceId", namespaceId);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/cs/config/beta").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<ConfigGrayInfo>>(){});
        return (ConfigGrayInfo)result.getData();
    }

    @Override
    public Map<String, Object> cloneConfig(String namespaceId, List<ConfigCloneInfo> cloneInfos, String srcUser, SameConfigPolicy policy) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", namespaceId);
        params.put("srcUser", srcUser);
        params.put("policy", policy.toString());
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("POST").setPath("/v3/admin/cs/config/clone").setParamValue(params).setBody(JacksonUtils.toJson(cloneInfos)).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Map<String, Object>>>(){});
        return (Map)result.getData();
    }

    @Override
    public Page<ConfigHistoryBasicInfo> listConfigHistory(String dataId, String groupName, String namespaceId, int pageNo, int pageSize) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("dataId", dataId);
        params.put("groupName", groupName);
        params.put("namespaceId", namespaceId);
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/cs/history/list").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Page<ConfigHistoryBasicInfo>>>(){});
        return (Page)result.getData();
    }

    @Override
    public ConfigHistoryDetailInfo getConfigHistoryInfo(String dataId, String groupName, String namespaceId, Long nid) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("dataId", dataId);
        params.put("groupName", groupName);
        params.put("namespaceId", namespaceId);
        params.put("nid", String.valueOf(nid));
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/cs/history").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<ConfigHistoryDetailInfo>>(){});
        return (ConfigHistoryDetailInfo)result.getData();
    }

    @Override
    public ConfigHistoryDetailInfo getPreviousConfigHistoryInfo(String dataId, String groupName, String namespaceId, Long id) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("dataId", dataId);
        params.put("groupName", groupName);
        params.put("namespaceId", namespaceId);
        params.put("id", String.valueOf(id));
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/cs/history/previous").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<ConfigHistoryDetailInfo>>(){});
        return (ConfigHistoryDetailInfo)result.getData();
    }

    @Override
    public List<ConfigBasicInfo> getConfigListByNamespace(String namespaceId) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", namespaceId);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/cs/history/configs").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<List<ConfigBasicInfo>>>(){});
        return (List)result.getData();
    }

    @Override
    public String updateLocalCacheFromStore() throws NacosException {
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("POST").setPath("/v3/admin/cs/ops/localCache").build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public String setLogLevel(String logName, String logLevel) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("logName", logName);
        params.put("logLevel", logLevel);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("PUT").setPath("/v3/admin/cs/ops/log").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public ConfigListenerInfo getAllSubClientConfigByIp(String ip, boolean all, String namespaceId, boolean aggregation) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("ip", ip);
        params.put("all", String.valueOf(all));
        params.put("namespaceId", namespaceId);
        params.put("aggregation", String.valueOf(aggregation));
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/cs/listener").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<ConfigListenerInfo>>(){});
        return (ConfigListenerInfo)result.getData();
    }
}

