/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.address;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.address.AbstractServerListManager;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.maintainer.client.remote.HttpClientManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerListManager
extends AbstractServerListManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServerListManager.class);
    private volatile String currentServerAddr;
    private Iterator<String> iterator;

    public DefaultServerListManager(NacosClientProperties properties) {
        super(properties);
    }

    protected NacosRestTemplate getNacosRestTemplate() {
        return HttpClientManager.getInstance().getNacosRestTemplate();
    }

    public void start() throws NacosException {
        super.start();
        this.iterator = this.iterator();
        this.currentServerAddr = this.iterator.next();
    }

    protected String getModuleName() {
        return "";
    }

    Iterator<String> iterator() {
        List serverList = this.getServerList();
        if (serverList.isEmpty()) {
            LOGGER.error("[iterator-serverlist] No server address defined!");
        }
        return new ServerAddressIterator(serverList);
    }

    public String genNextServer() {
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.refreshCurrentServerAddr();
            return this.currentServerAddr;
        }
        try {
            return this.iterator.next();
        }
        catch (Exception exception) {
            this.refreshCurrentServerAddr();
            return this.currentServerAddr;
        }
    }

    public String getCurrentServer() {
        if (StringUtils.isBlank((CharSequence)this.currentServerAddr)) {
            this.iterator = this.iterator();
            this.currentServerAddr = this.iterator.next();
        }
        return this.currentServerAddr;
    }

    public String getUrlString() {
        return this.getServerList().toString();
    }

    public String toString() {
        return "ServerManager--" + this.getUrlString();
    }

    public boolean contain(String ip) {
        return this.getServerList().contains(ip);
    }

    public void refreshCurrentServerAddr() {
        this.iterator = this.iterator();
        this.currentServerAddr = this.iterator.next();
    }

    public void updateCurrentServerAddr(String currentServerAddr) {
        this.currentServerAddr = currentServerAddr;
    }

    public Iterator<String> getIterator() {
        return this.iterator;
    }

    private static class ServerAddressIterator
    implements Iterator<String> {
        final List<RandomizedServerAddress> sorted = new ArrayList<RandomizedServerAddress>();
        final Iterator<RandomizedServerAddress> iter;

        public ServerAddressIterator(List<String> source) {
            for (String address : source) {
                this.sorted.add(new RandomizedServerAddress(address));
            }
            Collections.sort(this.sorted);
            this.iter = this.sorted.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public String next() {
            return this.iter.next().serverIp;
        }

        static class RandomizedServerAddress
        implements Comparable<RandomizedServerAddress> {
            static Random random = new Random();
            String serverIp;
            int seed;

            public RandomizedServerAddress(String ip) {
                this.serverIp = ip;
                this.seed = random.nextInt(Integer.MAX_VALUE);
            }

            @Override
            public int compareTo(RandomizedServerAddress other) {
                return other.seed - this.seed;
            }
        }
    }
}

