/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.lock.aspect;

import com.alibaba.nacos.api.lock.remote.request.LockOperationRequest;
import com.alibaba.nacos.api.lock.remote.response.LockOperationResponse;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.lock.monitor.LockMetricsMonitor;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RequestLockAspect {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..)) && target(com.alibaba.nacos.lock.remote.rpc.handler.LockRequestHandler) && args(request, meta)", argNames="request,meta")
    public Object lockMeterPoint(ProceedingJoinPoint pjp, LockOperationRequest request, RequestMeta meta) throws Throwable {
        long st = System.currentTimeMillis();
        try {
            LockMetricsMonitor.getTotalMeter(request.getLockOperationEnum()).incrementAndGet();
            LockOperationResponse result = (LockOperationResponse)pjp.proceed();
            if (result.isSuccess()) {
                LockMetricsMonitor.getSuccessMeter(request.getLockOperationEnum()).incrementAndGet();
            }
            LockOperationResponse lockOperationResponse = result;
            return lockOperationResponse;
        }
        finally {
            long rt = System.currentTimeMillis() - st;
            LockMetricsMonitor.getLockHandlerTimer().record(rt, TimeUnit.MILLISECONDS);
        }
    }
}

