/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.k8s.sync;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.filter.NacosPackageExcludeFilter;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sSyncEnabledFilter
implements NacosPackageExcludeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(K8sSyncEnabledFilter.class);
    private static final String K8S_SYNC_ENABLED_KEY = "nacos.k8s.sync.enabled";

    public String getResponsiblePackagePrefix() {
        return K8sSyncEnabledFilter.class.getPackage().getName();
    }

    public boolean isExcluded(String className, Set<String> annotationNames) {
        boolean k8sSyncDisabled;
        String functionMode = EnvUtil.getFunctionMode();
        if (this.isNamingDisabled(functionMode)) {
            LOGGER.warn("K8s Sync module disabled because function mode is {}, and K8s Sync depend naming module", (Object)functionMode);
            return true;
        }
        boolean bl = k8sSyncDisabled = (Boolean)EnvUtil.getProperty((String)K8S_SYNC_ENABLED_KEY, Boolean.class, (Object)false) == false;
        if (k8sSyncDisabled) {
            LOGGER.warn("K8s Sync module disabled because set {} as false", (Object)K8S_SYNC_ENABLED_KEY);
        }
        return k8sSyncDisabled;
    }

    private boolean isNamingDisabled(String functionMode) {
        if (StringUtils.isEmpty((String)functionMode)) {
            return false;
        }
        return !"naming".equals(functionMode);
    }
}

