/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.xds;

import com.alibaba.nacos.istio.api.ApiGenerator;
import com.alibaba.nacos.istio.misc.IstioConfig;
import com.alibaba.nacos.istio.model.IstioService;
import com.alibaba.nacos.istio.model.PushRequest;
import com.alibaba.nacos.istio.model.ServiceEntryWrapper;
import com.alibaba.nacos.istio.util.IstioCrdUtil;
import com.google.protobuf.Any;
import io.envoyproxy.envoy.service.discovery.v3.Resource;
import istio.mcp.v1alpha1.MetadataOuterClass;
import istio.mcp.v1alpha1.ResourceOuterClass;
import istio.networking.v1alpha3.ServiceEntryOuterClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ServiceEntryXdsGenerator
implements ApiGenerator<Any> {
    private static volatile ServiceEntryXdsGenerator singleton = null;
    private List<ServiceEntryWrapper> serviceEntries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceEntryXdsGenerator getInstance() {
        if (singleton != null) return singleton;
        Class<ServiceEntryXdsGenerator> clazz = ServiceEntryXdsGenerator.class;
        synchronized (ServiceEntryXdsGenerator.class) {
            if (singleton != null) return singleton;
            singleton = new ServiceEntryXdsGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    @Override
    public List<Any> generate(PushRequest pushRequest) {
        ArrayList<ResourceOuterClass.Resource> resources = new ArrayList<ResourceOuterClass.Resource>();
        this.serviceEntries = new ArrayList<ServiceEntryWrapper>(16);
        IstioConfig istioConfig = pushRequest.getResourceSnapshot().getIstioConfig();
        Map<String, IstioService> serviceInfoMap = pushRequest.getResourceSnapshot().getIstioResources().getIstioServiceMap();
        for (Map.Entry<String, IstioService> entry : serviceInfoMap.entrySet()) {
            String serviceName = entry.getKey();
            ServiceEntryWrapper serviceEntryWrapper = IstioCrdUtil.buildServiceEntry(serviceName, serviceName + istioConfig.getDomainSuffix(), serviceInfoMap.get(serviceName));
            if (serviceEntryWrapper == null) continue;
            this.serviceEntries.add(serviceEntryWrapper);
        }
        for (ServiceEntryWrapper serviceEntryWrapper : this.serviceEntries) {
            MetadataOuterClass.Metadata metadata = serviceEntryWrapper.getMetadata();
            ServiceEntryOuterClass.ServiceEntry serviceEntry = serviceEntryWrapper.getServiceEntry();
            Any any = Any.newBuilder().setValue(serviceEntry.toByteString()).setTypeUrl("type.googleapis.com/istio.networking.v1alpha3.ServiceEntry").build();
            resources.add(ResourceOuterClass.Resource.newBuilder().setBody(any).setMetadata(metadata).build());
        }
        ArrayList<Any> result = new ArrayList<Any>();
        for (ResourceOuterClass.Resource resource : resources) {
            result.add(Any.newBuilder().setValue(resource.toByteString()).setTypeUrl("type.googleapis.com/istio.mcp.v1alpha1.Resource").build());
        }
        return result;
    }

    @Override
    public List<Resource> deltaGenerate(PushRequest pushRequest) {
        if (pushRequest.isFull()) {
            return null;
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        this.serviceEntries = new ArrayList<ServiceEntryWrapper>();
        Set<String> reason = pushRequest.getReason();
        IstioConfig istioConfig = pushRequest.getResourceSnapshot().getIstioConfig();
        Map<String, IstioService> istioServiceMap = pushRequest.getResourceSnapshot().getIstioResources().getIstioServiceMap();
        if (pushRequest.getSubscribe().size() != 0) {
            for (String string : pushRequest.getSubscribe()) {
                String serviceName = IstioCrdUtil.parseServiceEntryNameToServiceName(string, istioConfig.getDomainSuffix());
                if (!reason.contains(serviceName)) continue;
                if (istioServiceMap.containsKey(serviceName)) {
                    serviceEntryWrapper = IstioCrdUtil.buildServiceEntry(serviceName, string, istioServiceMap.get(serviceName));
                    if (serviceEntryWrapper != null) {
                        this.serviceEntries.add(serviceEntryWrapper);
                        continue;
                    }
                    pushRequest.addRemoved(string);
                    continue;
                }
                pushRequest.addRemoved(string);
            }
        } else {
            for (Map.Entry entry : istioServiceMap.entrySet()) {
                String hostName = (String)entry.getKey() + "." + istioConfig.getDomainSuffix();
                serviceEntryWrapper = IstioCrdUtil.buildServiceEntry((String)entry.getKey(), hostName, (IstioService)entry.getValue());
                if (serviceEntryWrapper != null) {
                    this.serviceEntries.add(serviceEntryWrapper);
                    continue;
                }
                pushRequest.addRemoved(hostName);
            }
        }
        for (ServiceEntryWrapper serviceEntryWrapper : this.serviceEntries) {
            ServiceEntryOuterClass.ServiceEntry serviceEntry = serviceEntryWrapper.getServiceEntry();
            Any any = Any.newBuilder().setValue(serviceEntry.toByteString()).setTypeUrl("type.googleapis.com/istio.networking.v1alpha3.ServiceEntry").build();
            result.add(Resource.newBuilder().setResource(any).setVersion(pushRequest.getResourceSnapshot().getVersion()).build());
        }
        return result;
    }
}

