/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.util;

import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.core.utils.ClassUtils;
import com.alibaba.nacos.istio.IstioApp;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class IstioExecutor {
    private static final ExecutorService EVENT_HANDLE_EXECUTOR = ExecutorFactory.Managed.newSingleExecutorService((String)ClassUtils.getCanonicalName(IstioApp.class), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.istio.event.handle"));
    private static final ExecutorService PUSH_CHANGE_EXECUTOR = ExecutorFactory.Managed.newSingleExecutorService((String)ClassUtils.getCanonicalName(IstioApp.class), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.istio.pushchange.debounce"));
    private static final ExecutorService CYCLE_DEBOUNCE_EXECUTOR = ExecutorFactory.Managed.newSingleExecutorService((String)ClassUtils.getCanonicalName(IstioApp.class), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.istio.cycle.debounce"));

    public static <V> Future<V> asyncHandleEvent(Callable<V> task) {
        return EVENT_HANDLE_EXECUTOR.submit(task);
    }

    public static <V> Future<V> debouncePushChange(Callable<V> debounce) {
        return PUSH_CHANGE_EXECUTOR.submit(debounce);
    }

    public static void cycleDebounce(Runnable toNotify) {
        CYCLE_DEBOUNCE_EXECUTOR.submit(toNotify);
    }
}

