/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.impl.derby;

import com.alibaba.nacos.common.utils.ArrayUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.datasource.impl.derby.AbstractMapperByDerby;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigTagsRelationMapper;
import com.alibaba.nacos.plugin.datasource.mapper.ext.WhereBuilder;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.util.ArrayList;

public class ConfigInfoTagsRelationMapperByDerby
extends AbstractMapperByDerby
implements ConfigTagsRelationMapper {
    @Override
    public MapperResult findConfigInfo4PageFetchRows(MapperContext context) {
        String appName = (String)context.getWhereParameter("app_name");
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String content = (String)context.getWhereParameter("content");
        String tenantId = (String)context.getWhereParameter("tenantId");
        String[] tagArr = (String[])context.getWhereParameter("tagARR");
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder where = new StringBuilder(" WHERE ");
        String baseSql = "SELECT a.id,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content FROM config_info  a LEFT JOIN config_tags_relation b ON a.id=b.id";
        where.append(" a.tenant_id=? ");
        paramList.add(tenantId);
        if (StringUtils.isNotBlank((String)dataId)) {
            where.append(" AND a.data_id=? ");
            paramList.add(dataId);
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.append(" AND a.group_id=? ");
            paramList.add(group);
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.append(" AND a.app_name=? ");
            paramList.add(appName);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND a.content LIKE ? ");
            paramList.add(content);
        }
        where.append(" AND b.tag_name IN (");
        for (int i = 0; i < tagArr.length; ++i) {
            if (i != 0) {
                where.append(", ");
            }
            where.append('?');
            paramList.add(tagArr[i]);
        }
        where.append(") ");
        String sql = "SELECT a.id,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content FROM config_info  a LEFT JOIN config_tags_relation b ON a.id=b.id" + String.valueOf(where) + " OFFSET " + context.getStartRow() + " ROWS FETCH NEXT " + context.getPageSize() + " ROWS ONLY";
        return new MapperResult(sql, paramList);
    }

    @Override
    public MapperResult findConfigInfoLike4PageFetchRows(MapperContext context) {
        String appName = (String)context.getWhereParameter("app_name");
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String content = (String)context.getWhereParameter("content");
        String tenantId = (String)context.getWhereParameter("tenantId");
        Object[] tagArr = (String[])context.getWhereParameter("tagARR");
        Object[] types = (String[])context.getWhereParameter("type");
        WhereBuilder where = new WhereBuilder("SELECT a.ID,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content,a.type FROM config_info a LEFT JOIN config_tags_relation b ON a.id=b.id");
        where.like("a.tenant_id", tenantId);
        if (StringUtils.isNotBlank((String)dataId)) {
            where.and().like("a.data_id", dataId);
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.and().like("a.group_id", group);
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.and().eq("a.app_name", appName);
        }
        if (StringUtils.isNotBlank((String)content)) {
            where.and().like("a.content", content);
        }
        if (!ArrayUtils.isEmpty((Object[])tagArr)) {
            where.and().startParentheses();
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    where.or();
                }
                where.like("b.tag_name", tagArr[i]);
            }
            where.endParentheses();
        }
        if (!ArrayUtils.isEmpty((Object[])types)) {
            where.and().in("a.type", types);
        }
        where.offset(context.getStartRow(), context.getPageSize());
        return where.build();
    }

    @Override
    public String getDataSource() {
        return "derby";
    }
}

