/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.mapper.ext;

import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.util.ArrayList;
import java.util.List;

public final class WhereBuilder {
    private final String sql;
    private final List<Object> parameters = new ArrayList<Object>();
    private final StringBuilder where = new StringBuilder(" WHERE ");

    public WhereBuilder(String sql) {
        this.sql = sql;
    }

    public WhereBuilder and() {
        this.where.append(" AND ");
        return this;
    }

    public WhereBuilder or() {
        this.where.append(" OR ");
        return this;
    }

    public WhereBuilder eq(String filed, Object parameter) {
        this.where.append(filed).append(" = ? ");
        this.parameters.add(parameter);
        return this;
    }

    public WhereBuilder like(String filed, Object parameter) {
        this.where.append(filed).append(" LIKE ? ");
        this.parameters.add(parameter);
        return this;
    }

    public WhereBuilder in(String filed, Object[] parameterArr) {
        this.where.append(filed).append(" IN (");
        for (int i = 0; i < parameterArr.length; ++i) {
            if (i != 0) {
                this.where.append(", ");
            }
            this.where.append('?');
            this.parameters.add(parameterArr[i]);
        }
        this.where.append(") ");
        return this;
    }

    public WhereBuilder offset(int startRow, int pageSize) {
        this.where.append(" OFFSET ").append(startRow).append(" ROWS FETCH NEXT ").append(pageSize).append(" ROWS ONLY");
        return this;
    }

    public WhereBuilder limit(int startRow, int pageSize) {
        this.where.append(" LIMIT ").append(startRow).append(",").append(pageSize);
        return this;
    }

    public MapperResult build() {
        return new MapperResult(this.sql + String.valueOf(this.where), this.parameters);
    }
}

