/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.mapper;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.plugin.datasource.mapper.Mapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.util.ArrayList;
import java.util.List;

public interface ConfigMigrateMapper
extends Mapper {
    default public MapperResult getConfigConflictCount(MapperContext context) {
        String sql = "SELECT COUNT(*) AS count FROM config_info ci1 WHERE ci1.tenant_id = 'public' AND (ci1.src_user <> ? OR ci1.src_user IS NULL)  AND EXISTS (SELECT 1 FROM config_info ci2 WHERE ci2.data_id = ci1.data_id AND ci2.group_id = ci1.group_id AND ci2.tenant_id = '' AND (ci2.src_user <> ? OR ci2.src_user IS NULL))";
        Object srcUser = context.getWhereParameter("srcUser");
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{srcUser, srcUser}));
    }

    default public MapperResult findConfigIdNeedInsertMigrate(MapperContext context) {
        String sql = "SELECT ci.id FROM config_info ci WHERE ci.tenant_id = '' AND NOT EXISTS  ( SELECT 1 FROM config_info ci2  WHERE ci2.data_id = ci.data_id AND ci2.group_id = ci.group_id AND ci2.tenant_id = 'public' ) AND ci.id > ? ORDER BY ci.id LIMIT ?";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("id"), context.getPageSize()}));
    }

    default public MapperResult findConfigNeedUpdateMigrate(MapperContext context) {
        String sql = "SELECT ci.id, ci.data_id, ci.group_id, ci.tenant_id FROM config_info ci WHERE ci.tenant_id = ? AND  (ci.src_user <> ? OR ci.src_user IS NULL) AND EXISTS  ( SELECT 1 FROM config_info ci2 WHERE ci2.data_id = ci.data_id AND ci2.group_id = ci.group_id  AND ci2.tenant_id = ? AND ci2.src_user = ? AND ci2.md5 <> ci.md5  AND ci2.gmt_modified < ci.gmt_modified ) AND id > ? ORDER BY id LIMIT ?";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("srcTenant"), context.getWhereParameter("srcUser"), context.getWhereParameter("targetTenant"), context.getWhereParameter("srcUser"), context.getWhereParameter("id"), context.getPageSize()}));
    }

    default public MapperResult findConfigGrayNeedUpdateMigrate(MapperContext context) {
        String sql = "SELECT ci.id, ci.data_id, ci.group_id, ci.tenant_id, ci.gray_name  FROM config_info_gray ci WHERE ci.tenant_id = ? AND  (ci.src_user <> ? OR ci.src_user IS NULL) AND EXISTS  ( SELECT 1 FROM config_info_gray ci2 WHERE ci2.data_id = ci.data_id AND ci2.group_id = ci.group_id  AND ci2.gray_name = ci.gray_name AND ci2.tenant_id = ? AND ci2.src_user = ? AND ci2.md5 <> ci.md5  AND ci2.gmt_modified < ci.gmt_modified ) AND ci.id > ? ORDER BY ci.id LIMIT ?";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("srcTenant"), context.getWhereParameter("srcUser"), context.getWhereParameter("targetTenant"), context.getWhereParameter("srcUser"), context.getWhereParameter("id"), context.getPageSize()}));
    }

    default public MapperResult migrateConfigInsertByIds(MapperContext context) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder("INSERT INTO config_info (data_id, group_id, content, md5, src_user, src_ip, app_name, tenant_id, c_desc, type, encrypted_data_key) select data_id, group_id, content, md5, ?, src_ip, app_name, 'public', c_desc, type, encrypted_data_key from config_info WHERE ");
        sql.append("id IN (");
        List ids = (List)context.getWhereParameter("ids");
        paramList.add(context.getWhereParameter("srcUser"));
        for (int i = 0; i < ids.size(); ++i) {
            sql.append("? ");
            if (i < ids.size() - 1) {
                sql.append(", ");
            }
            paramList.add(ids.get(i));
        }
        sql.append(") ");
        return new MapperResult(sql.toString(), paramList);
    }

    default public MapperResult getConfigGrayConflictCount(MapperContext context) {
        String sql = "SELECT COUNT(*) AS count FROM config_info_gray ci1 WHERE ci1.tenant_id = 'public' AND (ci1.src_user <> ? OR ci1.src_user IS NULL) AND EXISTS (SELECT 1 FROM config_info_gray ci2 WHERE ci2.data_id = ci1.data_id AND ci2.group_id = ci1.group_id AND ci2.gray_name = ci1.gray_name AND ci2.tenant_id = '' AND (ci2.src_user <> ? OR ci1.src_user IS NULL))";
        Object srcUser = context.getWhereParameter("srcUser");
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{srcUser, srcUser}));
    }

    default public MapperResult findConfigGrayIdNeedInsertMigrate(MapperContext context) {
        String sql = "SELECT ci.id FROM config_info_gray ci WHERE ci.tenant_id = '' AND NOT EXISTS  ( SELECT 1 FROM config_info_gray ci2  WHERE ci2.data_id = ci.data_id AND ci2.group_id = ci.group_id AND ci2.tenant_id = 'public' AND ci2.gray_name = ci.gray_name ) AND ci.id > ? ORDER BY ci.id LIMIT ?";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("id"), context.getPageSize()}));
    }

    default public MapperResult migrateConfigGrayInsertByIds(MapperContext context) {
        StringBuilder sql = new StringBuilder("INSERT INTO config_info_gray (data_id, group_id, content, md5, src_user, src_ip, app_name, tenant_id, gray_name, gray_rule, encrypted_data_key) select data_id, group_id, content, md5, ?, src_ip, app_name, 'public', gray_name, gray_rule, encrypted_data_key from config_info_gray WHERE ");
        sql.append("id IN (");
        ArrayList<Object> paramList = new ArrayList<Object>();
        List ids = (List)context.getWhereParameter("ids");
        paramList.add(context.getWhereParameter("srcUser"));
        for (int i = 0; i < ids.size(); ++i) {
            sql.append("? ");
            if (i < ids.size() - 1) {
                sql.append(", ");
            }
            paramList.add(ids.get(i));
        }
        sql.append(") ");
        return new MapperResult(sql.toString(), paramList);
    }

    @Override
    default public String getTableName() {
        return "migrate_config";
    }
}

