/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.environment;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.environment.spi.CustomEnvironmentPluginService;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomEnvironmentPluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomEnvironmentPluginManager.class);
    private static final List<CustomEnvironmentPluginService> SERVICE_LIST = new LinkedList<CustomEnvironmentPluginService>();
    private static final CustomEnvironmentPluginManager INSTANCE = new CustomEnvironmentPluginManager();

    public CustomEnvironmentPluginManager() {
        this.loadInitial();
    }

    private void loadInitial() {
        Collection customEnvironmentPluginServices = NacosServiceLoader.load(CustomEnvironmentPluginService.class);
        for (CustomEnvironmentPluginService customEnvironmentPluginService : customEnvironmentPluginServices) {
            if (StringUtils.isBlank((CharSequence)customEnvironmentPluginService.pluginName())) {
                LOGGER.warn("[customEnvironmentPluginService] Load customEnvironmentPluginService({}) customEnvironmentPluginName(null/empty) fail. Please Add customEnvironmentPluginName to resolve.", customEnvironmentPluginService.getClass());
                continue;
            }
            LOGGER.info("[CustomEnvironmentPluginManager] Load customEnvironmentPluginService({}) customEnvironmentPluginName({}) successfully.", customEnvironmentPluginService.getClass(), (Object)customEnvironmentPluginService.pluginName());
        }
        SERVICE_LIST.addAll(customEnvironmentPluginServices.stream().sorted(Comparator.comparingInt(CustomEnvironmentPluginService::order)).collect(Collectors.toList()));
    }

    public static CustomEnvironmentPluginManager getInstance() {
        return INSTANCE;
    }

    public Set<String> getPropertyKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (CustomEnvironmentPluginService customEnvironmentPluginService : SERVICE_LIST) {
            keys.addAll(customEnvironmentPluginService.propertyKey());
        }
        return keys;
    }

    public Map<String, Object> getCustomValues(Map<String, Object> sourceProperty) {
        HashMap<String, Object> customValuesMap = new HashMap<String, Object>(1);
        for (CustomEnvironmentPluginService customEnvironmentPluginService : SERVICE_LIST) {
            Set<String> keys = customEnvironmentPluginService.propertyKey();
            HashMap<String, Object> propertyMap = new HashMap<String, Object>(keys.size());
            for (String key : keys) {
                propertyMap.put(key, sourceProperty.get(key));
            }
            Map<String, Object> targetPropertyMap = customEnvironmentPluginService.customValue(propertyMap);
            HashSet<String> targetKeys = new HashSet<String>(targetPropertyMap.keySet());
            targetKeys.removeAll(keys);
            for (String key : targetKeys) {
                targetPropertyMap.remove(key);
            }
            customValuesMap.putAll(targetPropertyMap);
        }
        customValuesMap.entrySet().removeIf(entry -> Objects.isNull(entry.getValue()));
        return customValuesMap;
    }

    public static synchronized void join(CustomEnvironmentPluginService customEnvironmentPluginService) {
        if (Objects.isNull(customEnvironmentPluginService)) {
            return;
        }
        SERVICE_LIST.add(customEnvironmentPluginService);
        LOGGER.info("[CustomEnvironmentPluginService] join successfully.");
    }
}

