/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.proxy.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.response.NacosMember;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.console.handler.core.ClusterHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.springframework.stereotype.Service;

@Service
public class ClusterProxy {
    private final ClusterHandler clusterHandler;

    public ClusterProxy(ClusterHandler clusterHandler) {
        this.clusterHandler = clusterHandler;
    }

    public Collection<NacosMember> getNodeList(String ipKeyWord) throws NacosException {
        Collection<? extends NacosMember> members = this.clusterHandler.getNodeList(ipKeyWord);
        ArrayList<NacosMember> result = new ArrayList<NacosMember>();
        members.forEach(member -> {
            if (StringUtils.isBlank((CharSequence)ipKeyWord)) {
                result.add((NacosMember)member);
                return;
            }
            String address = member.getAddress();
            if (StringUtils.equals((String)address, (String)ipKeyWord) || StringUtils.startsWith((CharSequence)address, (CharSequence)ipKeyWord)) {
                result.add((NacosMember)member);
            }
        });
        result.sort(Comparator.comparing(NacosMember::getAddress));
        return result;
    }
}

