/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.remote.naming;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.console.handler.impl.ConditionFunctionEnabled;
import com.alibaba.nacos.console.handler.impl.remote.EnabledRemoteHandler;
import com.alibaba.nacos.console.handler.impl.remote.NacosMaintainerClientHolder;
import com.alibaba.nacos.console.handler.naming.InstanceHandler;
import com.alibaba.nacos.core.utils.PageUtil;
import com.alibaba.nacos.naming.model.form.InstanceForm;
import java.util.List;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@EnabledRemoteHandler
@Conditional(value={ConditionFunctionEnabled.ConditionNamingEnabled.class})
public class InstanceRemoteHandler
implements InstanceHandler {
    private final NacosMaintainerClientHolder clientHolder;

    public InstanceRemoteHandler(NacosMaintainerClientHolder clientHolder) {
        this.clientHolder = clientHolder;
    }

    @Override
    public Page<? extends Instance> listInstances(String namespaceId, String serviceNameWithoutGroup, String groupName, String clusterName, int page, int pageSize) throws NacosException {
        List instances = this.clientHolder.getNamingMaintainerService().listInstances(namespaceId, groupName, serviceNameWithoutGroup, clusterName, false);
        return PageUtil.subPage((List)instances, (int)page, (int)pageSize);
    }

    @Override
    public void updateInstance(InstanceForm instanceForm, Instance instance) throws NacosException {
        this.clientHolder.getNamingMaintainerService().updateInstance(instanceForm.getNamespaceId(), instanceForm.getGroupName(), instanceForm.getServiceName(), instance);
    }
}

