/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.remote.config;

import com.alibaba.nacos.api.config.model.ConfigBasicInfo;
import com.alibaba.nacos.api.config.model.ConfigCloneInfo;
import com.alibaba.nacos.api.config.model.ConfigDetailInfo;
import com.alibaba.nacos.api.config.model.ConfigGrayInfo;
import com.alibaba.nacos.api.config.model.ConfigListenerInfo;
import com.alibaba.nacos.api.config.model.SameConfigPolicy;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.controller.parameters.SameNamespaceCloneConfigBean;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.console.handler.config.ConfigHandler;
import com.alibaba.nacos.console.handler.impl.ConditionFunctionEnabled;
import com.alibaba.nacos.console.handler.impl.remote.EnabledRemoteHandler;
import com.alibaba.nacos.console.handler.impl.remote.NacosMaintainerClientHolder;
import com.alibaba.nacos.console.handler.impl.remote.config.ConfigImportAndExportService;
import com.alibaba.nacos.maintainer.client.config.ConfigMaintainerService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@EnabledRemoteHandler
@Conditional(value={ConditionFunctionEnabled.ConditionConfigEnabled.class})
public class ConfigRemoteHandler
implements ConfigHandler {
    private final NacosMaintainerClientHolder clientHolder;
    private final ConfigImportAndExportService importAndExportService;

    public ConfigRemoteHandler(NacosMaintainerClientHolder clientHolder, ConfigImportAndExportService importAndExportService) {
        this.clientHolder = clientHolder;
        this.importAndExportService = importAndExportService;
    }

    @Override
    public Page<ConfigBasicInfo> getConfigList(int pageNo, int pageSize, String dataId, String group, String namespaceId, Map<String, Object> configAdvanceInfo) throws NacosException {
        String search = dataId.contains("*") ? "blur" : "accurate";
        return this.listConfigInfo(search, pageNo, pageSize, dataId, group, namespaceId, configAdvanceInfo);
    }

    @Override
    public ConfigDetailInfo getConfigDetail(String dataId, String group, String namespaceId) throws NacosException {
        try {
            return this.clientHolder.getConfigMaintainerService().getConfig(dataId, group, namespaceId);
        }
        catch (NacosException e) {
            if (404 == e.getErrCode()) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public Boolean publishConfig(ConfigForm configForm, ConfigRequestInfo configRequestInfo) throws NacosException {
        ConfigMaintainerService configMaintainerService = this.clientHolder.getConfigMaintainerService();
        if (StringUtils.isBlank((CharSequence)configRequestInfo.getBetaIps())) {
            return configMaintainerService.publishConfig(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configForm.getContent(), configForm.getAppName(), configForm.getSrcUser(), configForm.getConfigTags(), configForm.getDesc(), configForm.getType());
        }
        return configMaintainerService.publishBetaConfig(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configForm.getContent(), configForm.getAppName(), configForm.getSrcUser(), configForm.getConfigTags(), configForm.getDesc(), configForm.getType(), configRequestInfo.getBetaIps());
    }

    @Override
    public Boolean deleteConfig(String dataId, String group, String namespaceId, String tag, String clientIp, String srcUser) throws NacosException {
        return this.clientHolder.getConfigMaintainerService().deleteConfig(dataId, group, namespaceId);
    }

    @Override
    public Boolean batchDeleteConfigs(List<Long> ids, String clientIp, String srcUser) throws NacosException {
        return this.clientHolder.getConfigMaintainerService().deleteConfigs(ids);
    }

    @Override
    public Page<ConfigBasicInfo> getConfigListByContent(String search, int pageNo, int pageSize, String dataId, String group, String namespaceId, Map<String, Object> configAdvanceInfo) throws NacosException {
        return this.listConfigInfo(search, pageNo, pageSize, dataId, group, namespaceId, configAdvanceInfo);
    }

    @Override
    public ConfigListenerInfo getListeners(String dataId, String group, String namespaceId, boolean aggregation) throws Exception {
        return this.clientHolder.getConfigMaintainerService().getListeners(dataId, group, namespaceId, aggregation);
    }

    @Override
    public ConfigListenerInfo getAllSubClientConfigByIp(String ip, boolean all, String namespaceId, boolean aggregation) throws NacosException {
        return this.clientHolder.getConfigMaintainerService().getAllSubClientConfigByIp(ip, all, namespaceId, aggregation);
    }

    @Override
    public ResponseEntity<byte[]> exportConfig(String dataId, String group, String namespaceId, String appName, List<Long> ids) throws Exception {
        return this.importAndExportService.exportConfig(dataId, group, namespaceId, appName, ids);
    }

    @Override
    public Result<Map<String, Object>> importAndPublishConfig(String srcUser, String namespaceId, SameConfigPolicy policy, MultipartFile file, String srcIp, String requestIpApp) throws NacosException {
        return this.importAndExportService.importConfig(srcUser, namespaceId, policy, file, srcIp, requestIpApp);
    }

    @Override
    public Result<Map<String, Object>> cloneConfig(String srcUser, String namespaceId, List<SameNamespaceCloneConfigBean> configBeansList, SameConfigPolicy policy, String srcIp, String requestIpApp) throws NacosException {
        ArrayList configInfos = new ArrayList(configBeansList.size());
        configBeansList.forEach(sameNamespaceCloneConfigBean -> {
            ConfigCloneInfo configCloneInfo = new ConfigCloneInfo();
            configCloneInfo.setConfigId(sameNamespaceCloneConfigBean.getCfgId());
            configCloneInfo.setTargetDataId(sameNamespaceCloneConfigBean.getDataId());
            configCloneInfo.setTargetGroupName(sameNamespaceCloneConfigBean.getGroup());
            configInfos.add(configCloneInfo);
        });
        return Result.success((Object)this.clientHolder.getConfigMaintainerService().cloneConfig(namespaceId, configInfos, srcUser, policy));
    }

    @Override
    public boolean removeBetaConfig(String dataId, String group, String namespaceId, String remoteIp, String requestIpApp, String srcUser) throws NacosException {
        return this.clientHolder.getConfigMaintainerService().stopBeta(dataId, group, namespaceId);
    }

    @Override
    public ConfigGrayInfo queryBetaConfig(String dataId, String group, String namespaceId) throws NacosException {
        try {
            return this.clientHolder.getConfigMaintainerService().queryBeta(dataId, group, namespaceId);
        }
        catch (NacosException e) {
            if (404 == e.getErrCode()) {
                return null;
            }
            throw e;
        }
    }

    private Page<ConfigBasicInfo> listConfigInfo(String search, int pageNo, int pageSize, String dataId, String groupName, String namespaceId, Map<String, Object> configAdvanceInfo) throws NacosException {
        String type = this.getInfoFromAdvanceInfo(configAdvanceInfo, "types");
        String appName = this.getInfoFromAdvanceInfo(configAdvanceInfo, "appName");
        String configTags = this.getInfoFromAdvanceInfo(configAdvanceInfo, "config_tags");
        String configDetail = this.getInfoFromAdvanceInfo(configAdvanceInfo, "content");
        return this.clientHolder.getConfigMaintainerService().searchConfigByDetails(dataId, groupName, namespaceId, search, configDetail, type, configTags, appName, pageNo, pageSize);
    }

    private String getInfoFromAdvanceInfo(Map<String, Object> configAdvanceInfo, String key) {
        return configAdvanceInfo.containsKey(key) ? (String)configAdvanceInfo.get(key) : "";
    }
}

