/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.remote.ai;

import com.alibaba.nacos.ai.form.a2a.admin.AgentCardForm;
import com.alibaba.nacos.ai.form.a2a.admin.AgentCardUpdateForm;
import com.alibaba.nacos.ai.form.a2a.admin.AgentForm;
import com.alibaba.nacos.ai.form.a2a.admin.AgentListForm;
import com.alibaba.nacos.api.ai.model.a2a.AgentCard;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardDetailInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardVersionInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentVersionDetail;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.console.handler.ai.A2aHandler;
import com.alibaba.nacos.console.handler.impl.ConditionFunctionEnabled;
import com.alibaba.nacos.console.handler.impl.remote.EnabledRemoteHandler;
import com.alibaba.nacos.console.handler.impl.remote.NacosMaintainerClientHolder;
import com.alibaba.nacos.core.model.form.PageForm;
import com.alibaba.nacos.maintainer.client.ai.AiMaintainerService;
import java.util.List;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@EnabledRemoteHandler
@Conditional(value={ConditionFunctionEnabled.ConditionAiEnabled.class})
public class A2aRemoteHandler
implements A2aHandler {
    private final NacosMaintainerClientHolder clientHolder;

    public A2aRemoteHandler(NacosMaintainerClientHolder clientHolder) {
        this.clientHolder = clientHolder;
    }

    @Override
    public void registerAgent(AgentCard agentCard, AgentCardForm agentCardForm) throws NacosException {
        this.clientHolder.getAiMaintainerService().registerAgent(agentCard, agentCardForm.getNamespaceId(), agentCardForm.getRegistrationType());
    }

    @Override
    public AgentCardDetailInfo getAgentCardWithVersions(AgentForm form) throws NacosException {
        return this.clientHolder.getAiMaintainerService().getAgentCard(form.getAgentName(), form.getNamespaceId(), form.getRegistrationType());
    }

    @Override
    public void deleteAgent(AgentForm form) throws NacosException {
        this.clientHolder.getAiMaintainerService().deleteAgent(form.getAgentName(), form.getNamespaceId());
    }

    @Override
    public void updateAgentCard(AgentCard agentCard, AgentCardUpdateForm form) throws NacosException {
        this.clientHolder.getAiMaintainerService().updateAgentCard(agentCard, form.getNamespaceId(), form.getSetAsLatest(), form.getRegistrationType());
    }

    @Override
    public Page<AgentCardVersionInfo> listAgents(AgentListForm agentListForm, PageForm pageForm) throws NacosException {
        AiMaintainerService aiMaintainerService = this.clientHolder.getAiMaintainerService();
        return "blur".equalsIgnoreCase(agentListForm.getSearch()) ? aiMaintainerService.searchAgentCardsByName(agentListForm.getNamespaceId(), agentListForm.getAgentName(), pageForm.getPageNo(), pageForm.getPageSize()) : aiMaintainerService.listAgentCards(agentListForm.getNamespaceId(), agentListForm.getAgentName(), pageForm.getPageNo(), pageForm.getPageSize());
    }

    @Override
    public List<AgentVersionDetail> listAgentVersions(String namespaceId, String name) throws NacosException {
        return this.clientHolder.getAiMaintainerService().listAllVersionOfAgent(name, namespaceId);
    }
}

