/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.inner.naming;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.naming.pojo.maintainer.ServiceDetailInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.SubscriberInfo;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.trace.event.naming.DeregisterServiceTraceEvent;
import com.alibaba.nacos.common.trace.event.naming.RegisterServiceTraceEvent;
import com.alibaba.nacos.common.trace.event.naming.UpdateServiceTraceEvent;
import com.alibaba.nacos.console.handler.impl.ConditionFunctionEnabled;
import com.alibaba.nacos.console.handler.impl.inner.EnabledInnerHandler;
import com.alibaba.nacos.console.handler.naming.ServiceHandler;
import com.alibaba.nacos.naming.core.CatalogServiceV2Impl;
import com.alibaba.nacos.naming.core.ClusterOperatorV2Impl;
import com.alibaba.nacos.naming.core.ServiceOperatorV2Impl;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.model.form.ServiceForm;
import com.alibaba.nacos.naming.selector.SelectorManager;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@EnabledInnerHandler
@Conditional(value={ConditionFunctionEnabled.ConditionNamingEnabled.class})
public class ServiceInnerHandler
implements ServiceHandler {
    private final ServiceOperatorV2Impl serviceOperatorV2;
    private final SelectorManager selectorManager;
    private final CatalogServiceV2Impl catalogServiceV2;
    private final ClusterOperatorV2Impl clusterOperatorV2;

    @Autowired
    public ServiceInnerHandler(ServiceOperatorV2Impl serviceOperatorV2, SelectorManager selectorManager, CatalogServiceV2Impl catalogServiceV2, ClusterOperatorV2Impl clusterOperatorV2) {
        this.serviceOperatorV2 = serviceOperatorV2;
        this.selectorManager = selectorManager;
        this.catalogServiceV2 = catalogServiceV2;
        this.clusterOperatorV2 = clusterOperatorV2;
    }

    @Override
    public void createService(ServiceForm serviceForm, ServiceMetadata serviceMetadata) throws Exception {
        this.serviceOperatorV2.create(com.alibaba.nacos.naming.core.v2.pojo.Service.newService((String)serviceForm.getNamespaceId(), (String)serviceForm.getGroupName(), (String)serviceForm.getServiceName(), (boolean)serviceForm.getEphemeral()), serviceMetadata);
        NotifyCenter.publishEvent((Event)new RegisterServiceTraceEvent(System.currentTimeMillis(), serviceForm.getNamespaceId(), serviceForm.getGroupName(), serviceForm.getServiceName()));
    }

    @Override
    public void deleteService(String namespaceId, String serviceName, String groupName) throws Exception {
        this.serviceOperatorV2.delete(com.alibaba.nacos.naming.core.v2.pojo.Service.newService((String)namespaceId, (String)groupName, (String)serviceName));
        NotifyCenter.publishEvent((Event)new DeregisterServiceTraceEvent(System.currentTimeMillis(), namespaceId, groupName, serviceName));
    }

    @Override
    public void updateService(ServiceForm serviceForm, ServiceMetadata serviceMetadata) throws Exception {
        com.alibaba.nacos.naming.core.v2.pojo.Service service = com.alibaba.nacos.naming.core.v2.pojo.Service.newService((String)serviceForm.getNamespaceId(), (String)serviceForm.getGroupName(), (String)serviceForm.getServiceName());
        if (!ServiceManager.getInstance().containSingleton(service)) {
            throw new NacosApiException(404, ErrorCode.SERVICE_NOT_EXIST, "service %s is not exist.".formatted(service.toString()));
        }
        service = ServiceManager.getInstance().getSingleton(service);
        this.serviceOperatorV2.update(service, serviceMetadata);
        NotifyCenter.publishEvent((Event)new UpdateServiceTraceEvent(System.currentTimeMillis(), serviceForm.getNamespaceId(), serviceForm.getGroupName(), serviceForm.getServiceName(), serviceMetadata.getExtendData()));
    }

    @Override
    public List<String> getSelectorTypeList() throws NacosException {
        return this.selectorManager.getAllSelectorTypes();
    }

    @Override
    public Page<SubscriberInfo> getSubscribers(int pageNo, int pageSize, String namespaceId, String serviceName, String groupName, boolean aggregation) throws Exception {
        return this.serviceOperatorV2.getSubscribers(namespaceId, serviceName, groupName, aggregation, pageNo, pageSize);
    }

    @Override
    public Object getServiceList(boolean withInstances, String namespaceId, int pageNo, int pageSize, String serviceName, String groupName, boolean ignoreEmptyService) throws NacosException {
        if (withInstances) {
            return this.catalogServiceV2.pageListServiceDetail(namespaceId, groupName, serviceName, pageNo, pageSize);
        }
        return this.catalogServiceV2.listService(namespaceId, groupName, serviceName, pageNo, pageSize, ignoreEmptyService);
    }

    @Override
    public ServiceDetailInfo getServiceDetail(String namespaceId, String serviceName, String groupName) throws NacosException {
        return this.catalogServiceV2.getServiceDetail(namespaceId, groupName, serviceName);
    }

    @Override
    public void updateClusterMetadata(String namespaceId, String groupName, String serviceName, String clusterName, ClusterMetadata clusterMetadata) throws Exception {
        this.clusterOperatorV2.updateClusterMetadata(namespaceId, groupName, serviceName, clusterName, clusterMetadata);
    }
}

