/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.inner.ai;

import com.alibaba.nacos.ai.service.McpServerImportService;
import com.alibaba.nacos.ai.service.McpServerOperationService;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerImportRequest;
import com.alibaba.nacos.api.ai.model.mcp.McpServerImportResponse;
import com.alibaba.nacos.api.ai.model.mcp.McpServerImportValidationResult;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.console.handler.ai.McpHandler;
import com.alibaba.nacos.console.handler.impl.ConditionFunctionEnabled;
import com.alibaba.nacos.console.handler.impl.inner.EnabledInnerHandler;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@EnabledInnerHandler
@Conditional(value={ConditionFunctionEnabled.ConditionAiEnabled.class})
public class McpInnerHandler
implements McpHandler {
    private final McpServerOperationService mcpServerOperationService;
    private final McpServerImportService mcpServerImportService;

    public McpInnerHandler(McpServerOperationService mcpServerOperationService, McpServerImportService mcpServerImportService) {
        this.mcpServerOperationService = mcpServerOperationService;
        this.mcpServerImportService = mcpServerImportService;
    }

    @Override
    public Page<McpServerBasicInfo> listMcpServers(String namespaceId, String mcpName, String search, int pageNo, int pageSize) {
        return this.mcpServerOperationService.listMcpServerWithPage(namespaceId, mcpName, search, pageNo, pageSize);
    }

    @Override
    public McpServerDetailInfo getMcpServer(String namespaceId, String mcpName, String mcpServerId, String version) throws NacosException {
        return this.mcpServerOperationService.getMcpServerDetail(namespaceId, mcpServerId, mcpName, version);
    }

    @Override
    public String createMcpServer(String namespaceId, McpServerBasicInfo serverSpecification, McpToolSpecification toolSpecification, McpEndpointSpec endpointSpecification) throws NacosException {
        return this.mcpServerOperationService.createMcpServer(namespaceId, serverSpecification, toolSpecification, endpointSpecification);
    }

    @Override
    public void updateMcpServer(String namespaceId, boolean isPublish, McpServerBasicInfo serverSpecification, McpToolSpecification toolSpecification, McpEndpointSpec endpointSpecification, boolean overrideExisting) throws NacosException {
        this.mcpServerOperationService.updateMcpServer(namespaceId, isPublish, serverSpecification, toolSpecification, endpointSpecification, overrideExisting);
    }

    @Override
    public void deleteMcpServer(String namespaceId, String mcpName, String mcpServerId, String version) throws NacosException {
        this.mcpServerOperationService.deleteMcpServer(namespaceId, mcpName, mcpServerId, version);
    }

    @Override
    public McpServerImportValidationResult validateImport(String namespaceId, McpServerImportRequest request) throws NacosException {
        return this.mcpServerImportService.validateImport(namespaceId, request);
    }

    @Override
    public McpServerImportResponse executeImport(String namespaceId, McpServerImportRequest request) throws NacosException {
        return this.mcpServerImportService.executeImport(namespaceId, request);
    }
}

