/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.inner.ai;

import com.alibaba.nacos.ai.form.a2a.admin.AgentCardForm;
import com.alibaba.nacos.ai.form.a2a.admin.AgentCardUpdateForm;
import com.alibaba.nacos.ai.form.a2a.admin.AgentForm;
import com.alibaba.nacos.ai.form.a2a.admin.AgentListForm;
import com.alibaba.nacos.ai.service.a2a.A2aServerOperationService;
import com.alibaba.nacos.api.ai.model.a2a.AgentCard;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardDetailInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardVersionInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentVersionDetail;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.console.handler.ai.A2aHandler;
import com.alibaba.nacos.console.handler.impl.ConditionFunctionEnabled;
import com.alibaba.nacos.console.handler.impl.inner.EnabledInnerHandler;
import com.alibaba.nacos.core.model.form.PageForm;
import java.util.List;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@EnabledInnerHandler
@Conditional(value={ConditionFunctionEnabled.ConditionAiEnabled.class})
public class A2aInnerHandler
implements A2aHandler {
    private final A2aServerOperationService a2aServerOperationService;

    public A2aInnerHandler(A2aServerOperationService a2aServerOperationService) {
        this.a2aServerOperationService = a2aServerOperationService;
    }

    @Override
    public void registerAgent(AgentCard agentCard, AgentCardForm agentCardForm) throws NacosException {
        this.a2aServerOperationService.registerAgent(agentCard, agentCardForm.getNamespaceId(), agentCardForm.getRegistrationType());
    }

    @Override
    public AgentCardDetailInfo getAgentCardWithVersions(AgentForm form) throws NacosException {
        return this.a2aServerOperationService.getAgentCard(form.getNamespaceId(), form.getAgentName(), form.getVersion(), form.getRegistrationType());
    }

    @Override
    public void deleteAgent(AgentForm form) throws NacosException {
        this.a2aServerOperationService.deleteAgent(form.getNamespaceId(), form.getAgentName(), form.getVersion());
    }

    @Override
    public void updateAgentCard(AgentCard agentCard, AgentCardUpdateForm form) throws NacosException {
        this.a2aServerOperationService.updateAgentCard(agentCard, form.getNamespaceId(), form.getRegistrationType(), form.getSetAsLatest());
    }

    @Override
    public Page<AgentCardVersionInfo> listAgents(AgentListForm agentListForm, PageForm pageForm) throws NacosException {
        return this.a2aServerOperationService.listAgents(agentListForm.getNamespaceId(), agentListForm.getAgentName(), agentListForm.getSearch(), pageForm.getPageNo(), pageForm.getPageSize());
    }

    @Override
    public List<AgentVersionDetail> listAgentVersions(String namespaceId, String name) throws NacosException {
        return this.a2aServerOperationService.listAgentVersions(namespaceId, name);
    }
}

