/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.sys.env.EnvUtil;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class ConditionFunctionEnabled
implements Condition {
    private final String targetFunctionMode;

    public ConditionFunctionEnabled(String targetFunctionMode) {
        this.targetFunctionMode = targetFunctionMode;
    }

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String functionMode = EnvUtil.getFunctionMode();
        if (StringUtils.isEmpty((String)functionMode)) {
            return true;
        }
        return functionMode.equalsIgnoreCase(this.targetFunctionMode);
    }

    public static class ConditionAiEnabled
    extends ConditionFunctionEnabled {
        public ConditionAiEnabled() {
            super("");
        }
    }

    public static class ConditionConfigEnabled
    extends ConditionFunctionEnabled {
        public ConditionConfigEnabled() {
            super("config");
        }
    }

    public static class ConditionNamingEnabled
    extends ConditionFunctionEnabled {
        public ConditionNamingEnabled() {
            super("naming");
        }
    }
}

