/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller.v3.ai;

import com.alibaba.nacos.ai.form.mcp.admin.McpDetailForm;
import com.alibaba.nacos.ai.form.mcp.admin.McpForm;
import com.alibaba.nacos.ai.form.mcp.admin.McpImportForm;
import com.alibaba.nacos.ai.form.mcp.admin.McpListForm;
import com.alibaba.nacos.ai.form.mcp.admin.McpUpdateForm;
import com.alibaba.nacos.ai.param.McpHttpParamExtractor;
import com.alibaba.nacos.ai.utils.McpRequestUtil;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerImportRequest;
import com.alibaba.nacos.api.ai.model.mcp.McpServerImportResponse;
import com.alibaba.nacos.api.ai.model.mcp.McpServerImportValidationResult;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.console.proxy.ai.McpProxy;
import com.alibaba.nacos.core.model.form.PageForm;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.HttpClientSseClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.time.Duration;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/console/ai/mcp"})
@ExtractorManager.Extractor(httpExtractor=McpHttpParamExtractor.class)
public class ConsoleMcpController {
    private final McpProxy mcpProxy;

    public ConsoleMcpController(McpProxy mcpProxy) {
        this.mcpProxy = mcpProxy;
    }

    @GetMapping(value={"/list"})
    @Secured(action=ActionTypes.READ, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<Page<McpServerBasicInfo>> listMcpServers(McpListForm mcpListForm, PageForm pageForm) throws NacosException {
        mcpListForm.validate();
        pageForm.validate();
        return Result.success(this.mcpProxy.listMcpServers(mcpListForm.getNamespaceId(), mcpListForm.getMcpName(), mcpListForm.getSearch(), pageForm.getPageNo(), pageForm.getPageSize()));
    }

    @GetMapping(value={"/importToolsFromMcp"})
    @Secured(action=ActionTypes.WRITE, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<List<McpSchema.Tool>> importToolsFromMcp(@RequestParam String transportType, @RequestParam String baseUrl, @RequestParam String endpoint, @RequestParam(required=false) String authToken) throws NacosException {
        Result result;
        block11: {
            HttpClientSseClientTransport.Builder transportBuilder;
            HttpClientSseClientTransport transport = null;
            if (StringUtils.equals((CharSequence)transportType, (CharSequence)"mcp-sse")) {
                transportBuilder = HttpClientSseClientTransport.builder((String)baseUrl).sseEndpoint(endpoint);
                if (!StringUtils.isBlank((CharSequence)authToken)) {
                    transportBuilder.customizeRequest(req -> req.header("Authorization", "Bearer " + authToken));
                }
            } else {
                return Result.failure((Integer)ErrorCode.SERVER_ERROR.getCode(), (String)("Unsupported transport type: " + transportType), null);
            }
            transport = transportBuilder.build();
            McpSyncClient client = McpClient.sync((McpClientTransport)transport).requestTimeout(Duration.ofSeconds(10L)).build();
            try {
                client.initialize();
                McpSchema.ListToolsResult tools = client.listTools();
                result = Result.success((Object)tools.tools());
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new NacosException(500, "Failed to import tools from MCP server", (Throwable)e);
                }
            }
            client.close();
        }
        return result;
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<McpServerDetailInfo> getMcpServer(McpForm mcpForm) throws NacosException {
        mcpForm.validate();
        return Result.success((Object)this.mcpProxy.getMcpServer(mcpForm.getNamespaceId(), mcpForm.getMcpName(), mcpForm.getMcpId(), mcpForm.getVersion()));
    }

    @PostMapping
    @Secured(action=ActionTypes.WRITE, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<String> createMcpServer(McpDetailForm mcpForm) throws NacosException {
        mcpForm.validate();
        McpServerBasicInfo basicInfo = McpRequestUtil.parseMcpServerBasicInfo((McpDetailForm)mcpForm);
        McpToolSpecification mcpTools = McpRequestUtil.parseMcpTools((McpDetailForm)mcpForm);
        McpEndpointSpec endpointSpec = McpRequestUtil.parseMcpEndpointSpec((McpServerBasicInfo)basicInfo, (McpDetailForm)mcpForm);
        String mcpId = this.mcpProxy.createMcpServer(mcpForm.getNamespaceId(), basicInfo, mcpTools, endpointSpec);
        return Result.success((Object)mcpId);
    }

    @PutMapping
    @Secured(action=ActionTypes.WRITE, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<String> updateMcpServer(McpUpdateForm mcpForm) throws NacosException {
        mcpForm.validate();
        McpServerBasicInfo basicInfo = McpRequestUtil.parseMcpServerBasicInfo((McpDetailForm)mcpForm);
        McpToolSpecification mcpTools = McpRequestUtil.parseMcpTools((McpDetailForm)mcpForm);
        McpEndpointSpec endpointSpec = McpRequestUtil.parseMcpEndpointSpec((McpServerBasicInfo)basicInfo, (McpDetailForm)mcpForm);
        this.mcpProxy.updateMcpServer(mcpForm.getNamespaceId(), mcpForm.getLatest(), basicInfo, mcpTools, endpointSpec, mcpForm.isOverrideExisting());
        return Result.success((Object)"ok");
    }

    @DeleteMapping
    @Secured(action=ActionTypes.WRITE, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<String> deleteMcpServer(McpForm mcpForm) throws NacosException {
        mcpForm.validate();
        this.mcpProxy.deleteMcpServer(mcpForm.getNamespaceId(), mcpForm.getMcpName(), mcpForm.getMcpId(), mcpForm.getVersion());
        return Result.success((Object)"ok");
    }

    @PostMapping(value={"/import/validate"})
    @Secured(action=ActionTypes.WRITE, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<McpServerImportValidationResult> validateImport(McpImportForm mcpImportForm) throws NacosException {
        mcpImportForm.validate();
        McpServerImportRequest request = this.convertToImportRequest(mcpImportForm);
        McpServerImportValidationResult result = this.mcpProxy.validateImport(mcpImportForm.getNamespaceId(), request);
        return Result.success((Object)result);
    }

    @PostMapping(value={"/import/execute"})
    @Secured(action=ActionTypes.WRITE, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<McpServerImportResponse> executeImport(McpImportForm mcpImportForm) throws NacosException {
        mcpImportForm.validate();
        McpServerImportRequest request = this.convertToImportRequest(mcpImportForm);
        McpServerImportResponse response = this.mcpProxy.executeImport(mcpImportForm.getNamespaceId(), request);
        return Result.success((Object)response);
    }

    private McpServerImportRequest convertToImportRequest(McpImportForm form) {
        McpServerImportRequest request = new McpServerImportRequest();
        request.setImportType(form.getImportType());
        request.setData(form.getData());
        request.setOverrideExisting(form.isOverrideExisting());
        request.setValidateOnly(form.isValidateOnly());
        request.setSkipInvalid(form.isSkipInvalid());
        request.setSelectedServers(form.getSelectedServers());
        request.setCursor(form.getCursor());
        request.setLimit(form.getLimit());
        request.setSearch(form.getSearch());
        return request;
    }
}

