/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller.v3.ai;

import com.alibaba.nacos.ai.form.a2a.admin.AgentCardForm;
import com.alibaba.nacos.ai.form.a2a.admin.AgentCardUpdateForm;
import com.alibaba.nacos.ai.form.a2a.admin.AgentForm;
import com.alibaba.nacos.ai.form.a2a.admin.AgentListForm;
import com.alibaba.nacos.ai.param.AgentHttpParamExtractor;
import com.alibaba.nacos.ai.utils.AgentRequestUtil;
import com.alibaba.nacos.api.ai.model.a2a.AgentCard;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardDetailInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardVersionInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentVersionDetail;
import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.console.proxy.ai.A2aProxy;
import com.alibaba.nacos.core.model.form.PageForm;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/console/ai/a2a"})
@ExtractorManager.Extractor(httpExtractor=AgentHttpParamExtractor.class)
public class ConsoleA2aController {
    private final A2aProxy a2aProxy;

    public ConsoleA2aController(A2aProxy a2aProxy) {
        this.a2aProxy = a2aProxy;
    }

    @PostMapping
    @Secured(action=ActionTypes.WRITE, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<String> registerAgent(AgentCardForm form) throws NacosException {
        form.validate();
        AgentCard agentCard = AgentRequestUtil.parseAgentCard((AgentCardForm)form);
        this.a2aProxy.registerAgent(agentCard, form);
        return Result.success((Object)"ok");
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<AgentCardDetailInfo> getAgentCard(AgentForm form) throws NacosException {
        form.validate();
        return Result.success((Object)this.a2aProxy.getAgentCard(form));
    }

    @PutMapping
    @Secured(action=ActionTypes.WRITE, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<String> updateAgentCard(AgentCardUpdateForm form) throws NacosException {
        form.validate();
        AgentCard agentCard = AgentRequestUtil.parseAgentCard((AgentCardForm)form);
        this.a2aProxy.updateAgentCard(agentCard, form);
        return Result.success((Object)"ok");
    }

    @DeleteMapping
    @Secured(action=ActionTypes.WRITE, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<String> deleteAgent(AgentForm form) throws NacosException {
        form.validate();
        this.a2aProxy.deleteAgent(form);
        return Result.success((Object)"ok");
    }

    @GetMapping(value={"/list"})
    @Secured(action=ActionTypes.READ, signType="ai", apiType=ApiType.CONSOLE_API)
    public Result<Page<AgentCardVersionInfo>> listAgents(AgentListForm agentListForm, PageForm pageForm) throws NacosException {
        agentListForm.validate();
        pageForm.validate();
        return Result.success(this.a2aProxy.listAgents(agentListForm, pageForm));
    }

    @GetMapping(value={"/version/list"})
    @Secured(action=ActionTypes.READ, signType="ai", apiType=ApiType.ADMIN_API)
    public Result<List<AgentVersionDetail>> listAgentVersions(AgentForm agentForm) throws NacosException {
        agentForm.validate();
        return Result.success(this.a2aProxy.listAgentVersions(agentForm.getNamespaceId(), agentForm.getAgentName()));
    }
}

