/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.console.paramcheck.ConsoleDefaultHttpParamExtractor;
import com.alibaba.nacos.console.proxy.HealthProxy;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/console/health"})
@ExtractorManager.Extractor(httpExtractor=ConsoleDefaultHttpParamExtractor.class)
public class ConsoleHealthController {
    private final HealthProxy healthProxy;

    public ConsoleHealthController(HealthProxy healthProxy) {
        this.healthProxy = healthProxy;
    }

    @GetMapping(value={"/liveness"})
    public Result<String> liveness() {
        return Result.success((Object)"ok");
    }

    @GetMapping(value={"/readiness"})
    public ResponseEntity<Result<String>> readiness() throws NacosException {
        Result<String> ret = this.healthProxy.checkReadiness();
        if (ret.getCode() == 0) {
            return ResponseEntity.ok().body(ret);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(ret);
    }
}

