/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.remote.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.response.Namespace;
import com.alibaba.nacos.console.handler.core.NamespaceHandler;
import com.alibaba.nacos.console.handler.impl.remote.EnabledRemoteHandler;
import com.alibaba.nacos.console.handler.impl.remote.NacosMaintainerClientHolder;
import com.alibaba.nacos.core.namespace.model.form.NamespaceForm;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@EnabledRemoteHandler
public class NamespaceRemoteHandler
implements NamespaceHandler {
    private final NacosMaintainerClientHolder clientHolder;

    public NamespaceRemoteHandler(NacosMaintainerClientHolder clientHolder) {
        this.clientHolder = clientHolder;
    }

    @Override
    public List<Namespace> getNamespaceList() throws NacosException {
        return this.clientHolder.getNamingMaintainerService().getNamespaceList();
    }

    @Override
    public Namespace getNamespaceDetail(String namespaceId) throws NacosException {
        return this.clientHolder.getNamingMaintainerService().getNamespace(namespaceId);
    }

    @Override
    public Boolean createNamespace(String namespaceId, String namespaceName, String namespaceDesc) throws NacosException {
        return this.clientHolder.getNamingMaintainerService().createNamespace(namespaceId, namespaceName, namespaceDesc);
    }

    @Override
    public Boolean updateNamespace(NamespaceForm namespaceForm) throws NacosException {
        return this.clientHolder.getNamingMaintainerService().updateNamespace(namespaceForm.getNamespaceId(), namespaceForm.getNamespaceName(), namespaceForm.getNamespaceDesc());
    }

    @Override
    public Boolean deleteNamespace(String namespaceId) throws NacosException {
        return this.clientHolder.getNamingMaintainerService().deleteNamespace(namespaceId);
    }

    @Override
    public Boolean checkNamespaceIdExist(String namespaceId) throws NacosException {
        return this.clientHolder.getNamingMaintainerService().checkNamespaceIdExist(namespaceId);
    }
}

