/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.remote.config;

import com.alibaba.nacos.api.config.model.SameConfigPolicy;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.auth.config.NacosAuthConfigHolder;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.console.config.NacosConsoleAuthConfig;
import com.alibaba.nacos.console.handler.impl.remote.EnabledRemoteHandler;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.NacosMemberManager;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.AbstractHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@EnabledRemoteHandler
public class ConfigImportAndExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigImportAndExportService.class);
    private static final String REMOTE_CONFIG_IMPORT_URL = "http://%s%s/v3/admin/cs/config/import";
    private static final String REMOTE_CONFIG_EXPORT_URL = "http://%s%s/v3/admin/cs/config/export";
    private final NacosMemberManager memberManager;

    public ConfigImportAndExportService(NacosMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    public Result<Map<String, Object>> importConfig(String sourceUser, String namespaceId, SameConfigPolicy policy, MultipartFile importFile, String sourceIp, String sourceApp) {
        Result result;
        block9: {
            String serverContextPath = this.getServerContextPath();
            Member serverMember = this.randomOneMember();
            String url = String.format(REMOTE_CONFIG_IMPORT_URL, serverMember.getAddress(), serverContextPath);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                Query query = Query.newInstance().addParam("namespaceId", (Object)namespaceId).addParam("srcUser", (Object)sourceUser);
                URI uri = HttpUtils.buildUri((String)url, (Query)query);
                HttpPost httpPost = new HttpPost(uri);
                httpPost.setHeader("X-Forwarded-For", (Object)sourceIp);
                httpPost.setHeader("Client-AppName", (Object)sourceApp);
                this.addAuthIdentity((HttpRequest)httpPost);
                String contentTypeString = null == importFile.getContentType() ? "multipart/form-data" : importFile.getContentType();
                ContentType contentType = ContentType.create((String)contentTypeString, (String)"UTF-8");
                MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
                multipartEntityBuilder.addBinaryBody("file", importFile.getInputStream(), contentType, importFile.getOriginalFilename());
                multipartEntityBuilder.addTextBody("policy", policy.name(), contentType);
                HttpEntity entity = multipartEntityBuilder.build();
                httpPost.setEntity(entity);
                String executeResult = (String)httpClient.execute((ClassicHttpRequest)httpPost, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
                result = (Result)JacksonUtils.toObj((String)executeResult, (TypeReference)new TypeReference<Result<Map<String, Object>>>(){});
                if (httpClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HttpResponseException responseException) {
                    LOGGER.error("Import config to server {} failed with code {}: ", (Object)serverMember.getAddress(), (Object)responseException.getStatusCode());
                    throw new NacosRuntimeException(responseException.getStatusCode(), responseException.getMessage());
                }
                catch (IOException | URISyntaxException e) {
                    LOGGER.error("Import config to server {} failed: ", (Object)serverMember.getAddress(), (Object)e);
                    throw new NacosRuntimeException(500, "Import config to server failed.");
                }
            }
            httpClient.close();
        }
        return result;
    }

    public ResponseEntity<byte[]> exportConfig(String dataId, String group, String namespaceId, String appName, List<Long> ids) throws Exception {
        ResponseEntity responseEntity;
        block9: {
            String serverContextPath = this.getServerContextPath();
            Member serverMember = this.randomOneMember();
            String url = String.format(REMOTE_CONFIG_EXPORT_URL, serverMember.getAddress(), serverContextPath);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                Query query = Query.newInstance().addParam("namespaceId", (Object)namespaceId).addParam("dataId", (Object)dataId).addParam("groupName", (Object)group).addParam("ids", (Object)StringUtils.join(ids, (String)","));
                URI uri = HttpUtils.buildUri((String)url, (Query)query);
                HttpGet httpGet = new HttpGet(uri);
                this.addAuthIdentity((HttpRequest)httpGet);
                responseEntity = (ResponseEntity)httpClient.execute((ClassicHttpRequest)httpGet, (HttpClientResponseHandler)new ExportHttpClientResponseHandler());
                if (httpClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HttpResponseException responseException) {
                    LOGGER.error("Export config from server {} failed with code {}: ", (Object)serverMember.getAddress(), (Object)responseException.getStatusCode());
                    throw new NacosRuntimeException(responseException.getStatusCode(), responseException.getMessage());
                }
                catch (IOException | URISyntaxException e) {
                    LOGGER.error("Export config from server {} failed: ", (Object)serverMember.getAddress(), (Object)e);
                    throw new NacosRuntimeException(500, "Export config to server failed.");
                }
            }
            httpClient.close();
        }
        return responseEntity;
    }

    private void addAuthIdentity(HttpRequest request) {
        NacosAuthConfig authConfig = NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosConsoleAuthConfig.NACOS_CONSOLE_AUTH_SCOPE);
        if (StringUtils.isNotBlank((String)authConfig.getServerIdentityKey())) {
            request.setHeader(authConfig.getServerIdentityKey(), (Object)authConfig.getServerIdentityValue());
        }
    }

    private String getServerContextPath() {
        return EnvUtil.getProperty((String)"nacos.console.remote.server.context-path", (String)"/nacos");
    }

    private Member randomOneMember() {
        Collection allMembers = this.memberManager.allMembers();
        return (Member)allMembers.parallelStream().findAny().orElseThrow();
    }

    private static class ExportHttpClientResponseHandler
    extends AbstractHttpClientResponseHandler<ResponseEntity<byte[]>> {
        private String contentDisposition;

        private ExportHttpClientResponseHandler() {
        }

        public ResponseEntity<byte[]> handleResponse(ClassicHttpResponse response) throws IOException {
            try {
                this.contentDisposition = response.getHeader("Content-Disposition").getValue();
            }
            catch (ProtocolException e) {
                throw new NacosRuntimeException(500, "Export config from server, parse response file name failed; ", (Throwable)e);
            }
            return (ResponseEntity)super.handleResponse(response);
        }

        public ResponseEntity<byte[]> handleEntity(HttpEntity entity) throws IOException {
            InputStream inputStream = entity.getContent();
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                IoUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                byte[] responseBody = outputStream.toByteArray();
                ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{this.contentDisposition})).body((Object)responseBody);
                return responseEntity;
            }
        }
    }
}

