/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.remote.ai;

import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.console.handler.ai.McpHandler;
import com.alibaba.nacos.console.handler.impl.remote.EnabledRemoteHandler;
import com.alibaba.nacos.console.handler.impl.remote.NacosMaintainerClientHolder;
import org.springframework.stereotype.Service;

@Service
@EnabledRemoteHandler
public class McpRemoteHandler
implements McpHandler {
    private final NacosMaintainerClientHolder clientHolder;

    public McpRemoteHandler(NacosMaintainerClientHolder clientHolder) {
        this.clientHolder = clientHolder;
    }

    @Override
    public Page<McpServerBasicInfo> listMcpServers(String namespaceId, String mcpName, String search, int pageNo, int pageSize) throws NacosException {
        if ("accurate".equalsIgnoreCase(search)) {
            return this.clientHolder.getAiMaintainerService().listMcpServer(mcpName, pageNo, pageSize);
        }
        return this.clientHolder.getAiMaintainerService().searchMcpServer(mcpName, pageNo, pageSize);
    }

    @Override
    public McpServerDetailInfo getMcpServer(String namespaceId, String mcpName) throws NacosException {
        return this.clientHolder.getAiMaintainerService().getMcpServerDetail(mcpName);
    }

    @Override
    public void createMcpServer(String namespaceId, String mcpName, McpServerBasicInfo serverSpecification, McpToolSpecification toolSpecification, McpEndpointSpec endpointSpecification) throws NacosException {
        this.clientHolder.getAiMaintainerService().createMcpServer(mcpName, serverSpecification, toolSpecification, endpointSpecification);
    }

    @Override
    public void updateMcpServer(String namespaceId, String mcpName, McpServerBasicInfo serverSpecification, McpToolSpecification toolSpecification, McpEndpointSpec endpointSpecification) throws NacosException {
        this.clientHolder.getAiMaintainerService().updateMcpServer(mcpName, serverSpecification, toolSpecification, endpointSpecification);
    }

    @Override
    public void deleteMcpServer(String namespaceId, String mcpName) throws NacosException {
        this.clientHolder.getAiMaintainerService().deleteMcpServer(mcpName);
    }
}

