/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.inner.naming;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.trace.event.naming.UpdateInstanceTraceEvent;
import com.alibaba.nacos.console.handler.impl.inner.EnabledInnerHandler;
import com.alibaba.nacos.console.handler.naming.InstanceHandler;
import com.alibaba.nacos.core.utils.PageUtil;
import com.alibaba.nacos.naming.core.CatalogService;
import com.alibaba.nacos.naming.core.CatalogServiceV2Impl;
import com.alibaba.nacos.naming.core.InstanceOperatorClientImpl;
import com.alibaba.nacos.naming.model.form.InstanceForm;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@EnabledInnerHandler
public class InstanceInnerHandler
implements InstanceHandler {
    private final CatalogService catalogService;
    private final InstanceOperatorClientImpl instanceServiceV2;

    public InstanceInnerHandler(CatalogServiceV2Impl catalogServiceV2, InstanceOperatorClientImpl instanceServiceV2) {
        this.catalogService = catalogServiceV2;
        this.instanceServiceV2 = instanceServiceV2;
    }

    @Override
    public Page<? extends Instance> listInstances(String namespaceId, String serviceNameWithoutGroup, String groupName, String clusterName, int page, int pageSize) throws NacosException {
        List instances = this.catalogService.listInstances(namespaceId, groupName, serviceNameWithoutGroup, clusterName);
        return PageUtil.subPage((List)instances, (int)page, (int)pageSize);
    }

    @Override
    public void updateInstance(InstanceForm instanceForm, Instance instance) throws NacosException {
        this.instanceServiceV2.updateInstance(instanceForm.getNamespaceId(), instanceForm.getGroupName(), instanceForm.getServiceName(), instance);
        NotifyCenter.publishEvent((Event)new UpdateInstanceTraceEvent(System.currentTimeMillis(), "", instanceForm.getNamespaceId(), instanceForm.getGroupName(), instanceForm.getServiceName(), instance.getIp(), instance.getPort(), instance.getMetadata()));
    }
}

