/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.inner.config;

import com.alibaba.nacos.api.config.model.ConfigBasicInfo;
import com.alibaba.nacos.api.config.model.ConfigDetailInfo;
import com.alibaba.nacos.api.config.model.ConfigGrayInfo;
import com.alibaba.nacos.api.config.model.ConfigListenerInfo;
import com.alibaba.nacos.api.config.model.SameConfigPolicy;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.utils.DateFormatUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.controller.parameters.SameNamespaceCloneConfigBean;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoGrayWrapper;
import com.alibaba.nacos.config.server.model.ConfigMetadata;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.event.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.service.ConfigChangePublisher;
import com.alibaba.nacos.config.server.service.ConfigDetailService;
import com.alibaba.nacos.config.server.service.ConfigMigrateService;
import com.alibaba.nacos.config.server.service.ConfigOperationService;
import com.alibaba.nacos.config.server.service.listener.ConfigListenerStateDelegate;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.GroupKey;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.ResponseUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.config.server.utils.YamlParserUtil;
import com.alibaba.nacos.config.server.utils.ZipUtils;
import com.alibaba.nacos.console.handler.config.ConfigHandler;
import com.alibaba.nacos.console.handler.impl.inner.EnabledInnerHandler;
import com.alibaba.nacos.core.namespace.repository.NamespacePersistService;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import com.alibaba.nacos.sys.utils.InetUtils;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Service
@EnabledInnerHandler
public class ConfigInnerHandler
implements ConfigHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigInnerHandler.class);
    private static final String EXPORT_CONFIG_FILE_NAME = "nacos_config_export_";
    private static final String EXPORT_CONFIG_FILE_NAME_EXT = ".zip";
    private static final String EXPORT_CONFIG_FILE_NAME_DATE_FORMAT = "yyyyMMddHHmmss";
    private final ConfigInfoPersistService configInfoPersistService;
    private final ConfigOperationService configOperationService;
    private final ConfigDetailService configDetailService;
    private final ConfigListenerStateDelegate configListenerStateDelegate;
    private final ConfigMigrateService configMigrateService;
    private NamespacePersistService namespacePersistService;
    private ConfigInfoBetaPersistService configInfoBetaPersistService;
    private ConfigInfoGrayPersistService configInfoGrayPersistService;

    public ConfigInnerHandler(ConfigOperationService configOperationService, ConfigInfoPersistService configInfoPersistService, ConfigDetailService configDetailService, NamespacePersistService namespacePersistService, ConfigInfoBetaPersistService configInfoBetaPersistService, ConfigInfoGrayPersistService configInfoGrayPersistService, ConfigListenerStateDelegate configListenerStateDelegate, ConfigMigrateService configMigrateService) {
        this.configOperationService = configOperationService;
        this.configInfoPersistService = configInfoPersistService;
        this.configDetailService = configDetailService;
        this.namespacePersistService = namespacePersistService;
        this.configInfoBetaPersistService = configInfoBetaPersistService;
        this.configInfoGrayPersistService = configInfoGrayPersistService;
        this.configListenerStateDelegate = configListenerStateDelegate;
        this.configMigrateService = configMigrateService;
    }

    @Override
    public Page<ConfigBasicInfo> getConfigList(int pageNo, int pageSize, String dataId, String group, String namespaceId, Map<String, Object> configAdvanceInfo) throws IOException, ServletException, NacosException {
        Page result = this.configInfoPersistService.findConfigInfoLike4Page(pageNo, pageSize, dataId, group, namespaceId, configAdvanceInfo);
        return this.transferToConfigBasicInfo((Page<ConfigInfo>)result);
    }

    @Override
    public ConfigDetailInfo getConfigDetail(String dataId, String group, String namespaceId) throws NacosException {
        ConfigAllInfo configAllInfo = this.configInfoPersistService.findConfigAllInfo(dataId, group, namespaceId);
        if (null == configAllInfo) {
            return null;
        }
        return ResponseUtil.transferToConfigDetailInfo((ConfigAllInfo)configAllInfo);
    }

    @Override
    public Boolean publishConfig(ConfigForm configForm, ConfigRequestInfo configRequestInfo) throws NacosException {
        String encryptedDataKeyFinal = configForm.getEncryptedDataKey();
        if (StringUtils.isBlank((CharSequence)encryptedDataKeyFinal)) {
            Pair pair = EncryptionHandler.encryptHandler((String)configForm.getDataId(), (String)configForm.getContent());
            configForm.setContent((String)pair.getSecond());
            encryptedDataKeyFinal = (String)pair.getFirst();
        }
        return this.configOperationService.publishConfig(configForm, configRequestInfo, encryptedDataKeyFinal);
    }

    @Override
    public Boolean deleteConfig(String dataId, String group, String namespaceId, String tag, String clientIp, String srcUser) throws NacosException {
        return this.configOperationService.deleteConfig(dataId, group, namespaceId, tag, clientIp, srcUser, "http");
    }

    @Override
    public Boolean batchDeleteConfigs(List<Long> ids, String clientIp, String srcUser) {
        for (Long id : ids) {
            ConfigInfo configInfo = this.configInfoPersistService.findConfigInfo(id.longValue());
            if (configInfo == null) {
                LOGGER.warn("[deleteConfigs] configInfo is null, id: {}", (Object)id);
                continue;
            }
            this.configOperationService.deleteConfig(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), null, clientIp, srcUser, "http");
        }
        return true;
    }

    @Override
    public Page<ConfigBasicInfo> getConfigListByContent(String search, int pageNo, int pageSize, String dataId, String group, String namespaceId, Map<String, Object> configAdvanceInfo) throws NacosException {
        try {
            Page result = this.configDetailService.findConfigInfoPage(search, pageNo, pageSize, dataId, group, namespaceId, configAdvanceInfo);
            return this.transferToConfigBasicInfo((Page<ConfigInfo>)result);
        }
        catch (Exception e) {
            String errorMsg = "serialize page error, dataId=" + dataId + ", group=" + group;
            LOGGER.error(errorMsg, (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigListenerInfo getListeners(String dataId, String group, String namespaceId, boolean aggregation) throws Exception {
        return this.configListenerStateDelegate.getListenerState(dataId, group, namespaceId, aggregation);
    }

    @Override
    public ConfigListenerInfo getAllSubClientConfigByIp(String ip, boolean all, String namespaceId, boolean aggregation) {
        ConfigListenerInfo result = this.configListenerStateDelegate.getListenerStateByIp(ip, aggregation);
        result.setQueryType("ip");
        HashMap<String, String> configMd5Status = new HashMap<String, String>(100);
        if (result.getListenersStatus() == null || result.getListenersStatus().isEmpty()) {
            return result;
        }
        Map status = result.getListenersStatus();
        for (Map.Entry config : status.entrySet()) {
            if (!StringUtils.isBlank((CharSequence)namespaceId) && ((String)config.getKey()).contains(namespaceId)) {
                configMd5Status.put((String)config.getKey(), (String)config.getValue());
                continue;
            }
            if (all) {
                configMd5Status.put((String)config.getKey(), (String)config.getValue());
                continue;
            }
            String[] configKeys = GroupKey2.parseKey((String)((String)config.getKey()));
            if (!StringUtils.isBlank((CharSequence)configKeys[2])) continue;
            configMd5Status.put((String)config.getKey(), (String)config.getValue());
        }
        result.setListenersStatus(configMd5Status);
        return result;
    }

    @Override
    public ResponseEntity<byte[]> exportConfig(String dataId, String group, String namespaceId, String appName, List<Long> ids) throws Exception {
        List dataList = this.configInfoPersistService.findAllConfigInfo4Export(dataId, group, namespaceId, appName, ids);
        ArrayList<ZipUtils.ZipItem> zipItemList = new ArrayList<ZipUtils.ZipItem>();
        ArrayList<ConfigMetadata.ConfigExportItem> configMetadataItems = new ArrayList<ConfigMetadata.ConfigExportItem>();
        for (ConfigAllInfo ci : dataList) {
            ConfigMetadata.ConfigExportItem configMetadataItem = new ConfigMetadata.ConfigExportItem();
            configMetadataItem.setAppName(ci.getAppName());
            configMetadataItem.setDataId(ci.getDataId());
            configMetadataItem.setDesc(ci.getDesc());
            configMetadataItem.setGroup(ci.getGroup());
            configMetadataItem.setType(ci.getType());
            configMetadataItems.add(configMetadataItem);
            Pair pair = EncryptionHandler.decryptHandler((String)ci.getDataId(), (String)ci.getEncryptedDataKey(), (String)ci.getContent());
            String itemName = ci.getGroup() + "/" + ci.getDataId();
            zipItemList.add(new ZipUtils.ZipItem(itemName, (String)pair.getSecond()));
        }
        ConfigMetadata configMetadata = new ConfigMetadata();
        configMetadata.setMetadata(configMetadataItems);
        zipItemList.add(new ZipUtils.ZipItem(".metadata.yml", YamlParserUtil.dumpObject((Object)configMetadata)));
        HttpHeaders headers = new HttpHeaders();
        String fileName = EXPORT_CONFIG_FILE_NAME + DateFormatUtils.format((Date)new Date(), (String)EXPORT_CONFIG_FILE_NAME_DATE_FORMAT) + EXPORT_CONFIG_FILE_NAME_EXT;
        headers.add("Content-Disposition", "attachment;filename=" + fileName);
        return new ResponseEntity((Object)ZipUtils.zip(zipItemList), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @Override
    public Result<Map<String, Object>> importAndPublishConfig(String srcUser, String namespaceId, SameConfigPolicy policy, MultipartFile file, String srcIp, String requestIpApp) throws NacosException {
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        if (Objects.isNull(file)) {
            return Result.failure((ErrorCode)ErrorCode.DATA_EMPTY, failedData);
        }
        if (StringUtils.isNotBlank((String)namespaceId) && !NamespaceUtil.isDefaultNamespaceId((String)namespaceId) && this.namespacePersistService.tenantInfoCountByTenantId(namespaceId) <= 0) {
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.NAMESPACE_NOT_EXIST, failedData);
        }
        ArrayList<ConfigAllInfo> configInfoList = new ArrayList<ConfigAllInfo>();
        ArrayList<Map<String, String>> unrecognizedList = new ArrayList<Map<String, String>>();
        try {
            ZipUtils.UnZipResult unziped = ZipUtils.unzip((byte[])file.getBytes());
            ZipUtils.ZipItem metaDataZipItem = unziped.getMetaDataItem();
            Result<Map<String, Object>> errorResult = metaDataZipItem != null && ".metadata.yml".equals(metaDataZipItem.getItemName()) ? this.parseImportDataV2(srcUser, unziped, configInfoList, unrecognizedList, namespaceId) : this.parseImportData(srcUser, unziped, configInfoList, unrecognizedList, namespaceId);
            if (errorResult != null) {
                return errorResult;
            }
        }
        catch (IOException e) {
            failedData.put("succCount", 0);
            LOGGER.error("parsing data failed", (Throwable)e);
            return Result.failure((ErrorCode)ErrorCode.PARSING_DATA_FAILED, failedData);
        }
        if (CollectionUtils.isEmpty(configInfoList)) {
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.DATA_EMPTY, failedData);
        }
        Timestamp time = TimeUtils.getCurrentTime();
        Map saveResult = this.configInfoPersistService.batchInsertOrUpdate(configInfoList, srcUser, srcIp, null, policy);
        for (ConfigInfo configInfo : configInfoList) {
            ConfigChangePublisher.notifyConfigChange((ConfigDataChangeEvent)new ConfigDataChangeEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
            ConfigTraceService.logPersistenceEvent((String)configInfo.getDataId(), (String)configInfo.getGroup(), (String)configInfo.getTenant(), (String)requestIpApp, (long)time.getTime(), (String)InetUtils.getSelfIP(), (String)"persist", (String)"pub", (String)configInfo.getContent());
        }
        if (!unrecognizedList.isEmpty()) {
            saveResult.put("unrecognizedCount", unrecognizedList.size());
            saveResult.put("unrecognizedData", unrecognizedList);
        }
        return Result.success((Object)saveResult);
    }

    private Result<Map<String, Object>> parseImportData(String srcUser, ZipUtils.UnZipResult unziped, List<ConfigAllInfo> configInfoList, List<Map<String, String>> unrecognizedList, String namespace) {
        List itemList;
        ZipUtils.ZipItem metaDataZipItem = unziped.getMetaDataItem();
        HashMap<String, String> metaDataMap = new HashMap<String, String>(16);
        if (metaDataZipItem != null) {
            String metaDataStr = metaDataZipItem.getItemData().replaceAll("[\r\n]+", "|");
            String[] metaDataArr = metaDataStr.split("\\|");
            HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
            for (String metaDataItem : metaDataArr) {
                String[] metaDataItemArr = metaDataItem.split("=");
                if (metaDataItemArr.length != 2) {
                    failedData.put("succCount", 0);
                    return Result.failure((ErrorCode)ErrorCode.METADATA_ILLEGAL, failedData);
                }
                metaDataMap.put(metaDataItemArr[0], metaDataItemArr[1]);
            }
        }
        if ((itemList = unziped.getZipItemList()) != null && !itemList.isEmpty()) {
            for (ZipUtils.ZipItem item : itemList) {
                String[] groupAdnDataId = item.getItemName().split("/");
                if (groupAdnDataId.length != 2) {
                    HashMap<String, String> unrecognizedItem = new HashMap<String, String>(2);
                    unrecognizedItem.put("itemName", item.getItemName());
                    unrecognizedList.add(unrecognizedItem);
                    continue;
                }
                String group = groupAdnDataId[0];
                String dataId = groupAdnDataId[1];
                Object tempDataId = dataId;
                if (((String)tempDataId).contains(".")) {
                    tempDataId = ((String)tempDataId).substring(0, ((String)tempDataId).lastIndexOf(".")) + "~" + ((String)tempDataId).substring(((String)tempDataId).lastIndexOf(".") + 1);
                }
                String metaDataId = group + "." + (String)tempDataId + ".app";
                String content = item.getItemData();
                Pair pair = EncryptionHandler.encryptHandler((String)dataId, (String)content);
                content = (String)pair.getSecond();
                ConfigAllInfo ci = new ConfigAllInfo();
                ci.setGroup(group);
                ci.setDataId(dataId);
                ci.setContent(content);
                if (metaDataMap.get(metaDataId) != null) {
                    ci.setAppName((String)metaDataMap.get(metaDataId));
                }
                ci.setTenant(namespace);
                ci.setEncryptedDataKey((String)pair.getFirst());
                ci.setCreateUser(srcUser);
                configInfoList.add(ci);
            }
        }
        return null;
    }

    private Result<Map<String, Object>> parseImportDataV2(String srcUser, ZipUtils.UnZipResult unziped, List<ConfigAllInfo> configInfoList, List<Map<String, String>> unrecognizedList, String namespace) {
        ZipUtils.ZipItem metaDataItem = unziped.getMetaDataItem();
        String metaData = metaDataItem.getItemData();
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        ConfigMetadata configMetadata = (ConfigMetadata)YamlParserUtil.loadObject((String)metaData, ConfigMetadata.class);
        if (configMetadata == null || CollectionUtils.isEmpty((Collection)configMetadata.getMetadata())) {
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.METADATA_ILLEGAL, failedData);
        }
        List configExportItems = configMetadata.getMetadata();
        for (ConfigMetadata.ConfigExportItem configExportItem : configExportItems) {
            if (!StringUtils.isBlank((CharSequence)configExportItem.getDataId()) && !StringUtils.isBlank((CharSequence)configExportItem.getGroup()) && !StringUtils.isBlank((CharSequence)configExportItem.getType())) continue;
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.METADATA_ILLEGAL, failedData);
        }
        List zipItemList = unziped.getZipItemList();
        Set metaDataKeys = configExportItems.stream().map(metaItem -> GroupKey.getKey((String)metaItem.getDataId(), (String)metaItem.getGroup())).collect(Collectors.toSet());
        HashMap configContentMap = new HashMap(zipItemList.size());
        int itemNameLength = 2;
        zipItemList.forEach(item -> {
            String itemName = item.getItemName();
            String[] groupAdnDataId = itemName.split("/");
            if (groupAdnDataId.length != itemNameLength) {
                HashMap<String, String> unrecognizedItem = new HashMap<String, String>(2);
                unrecognizedItem.put("itemName", item.getItemName());
                unrecognizedList.add(unrecognizedItem);
                return;
            }
            String dataId = groupAdnDataId[1];
            String group = groupAdnDataId[0];
            String key = GroupKey.getKey((String)dataId, (String)group);
            if (!metaDataKeys.contains(key)) {
                HashMap<String, CallSite> unrecognizedItem = new HashMap<String, CallSite>(2);
                unrecognizedItem.put("itemName", (CallSite)((Object)("\u672a\u5728\u5143\u6570\u636e\u4e2d\u627e\u5230: " + item.getItemName())));
                unrecognizedList.add(unrecognizedItem);
                return;
            }
            String itemData = item.getItemData();
            configContentMap.put(key, itemData);
        });
        for (ConfigMetadata.ConfigExportItem configExportItem : configExportItems) {
            String group;
            String dataId = configExportItem.getDataId();
            String content = (String)configContentMap.get(GroupKey.getKey((String)dataId, (String)(group = configExportItem.getGroup())));
            if (content == null) {
                HashMap<String, CallSite> unrecognizedItem = new HashMap<String, CallSite>(2);
                unrecognizedItem.put("itemName", (CallSite)((Object)("\u672a\u5728\u6587\u4ef6\u4e2d\u627e\u5230: " + group + "/" + dataId)));
                unrecognizedList.add(unrecognizedItem);
                continue;
            }
            Pair pair = EncryptionHandler.encryptHandler((String)dataId, (String)content);
            content = (String)pair.getSecond();
            ConfigAllInfo ci = new ConfigAllInfo();
            ci.setGroup(group);
            ci.setDataId(dataId);
            ci.setContent(content);
            ci.setType(configExportItem.getType());
            ci.setDesc(configExportItem.getDesc());
            ci.setAppName(configExportItem.getAppName());
            ci.setTenant(namespace);
            ci.setEncryptedDataKey((String)pair.getFirst());
            ci.setCreateUser(srcUser);
            configInfoList.add(ci);
        }
        return null;
    }

    @Override
    public Result<Map<String, Object>> cloneConfig(String srcUser, String namespaceId, List<SameNamespaceCloneConfigBean> configBeansList, SameConfigPolicy policy, String srcIp, String requestIpApp) throws NacosException {
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        if (CollectionUtils.isEmpty(configBeansList)) {
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.NO_SELECTED_CONFIG, failedData);
        }
        if (StringUtils.isNotBlank((String)namespaceId) && !NamespaceUtil.isDefaultNamespaceId((String)namespaceId) && this.namespacePersistService.tenantInfoCountByTenantId(namespaceId) <= 0) {
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.NAMESPACE_NOT_EXIST, failedData);
        }
        ArrayList idList = new ArrayList(configBeansList.size());
        Map<Long, SameNamespaceCloneConfigBean> configBeansMap = configBeansList.stream().collect(Collectors.toMap(SameNamespaceCloneConfigBean::getCfgId, cfg -> {
            idList.add(cfg.getCfgId());
            return cfg;
        }, (k1, k2) -> k1));
        List queryedDataList = this.configInfoPersistService.findAllConfigInfo4Export(null, null, null, null, idList);
        if (queryedDataList == null || queryedDataList.isEmpty()) {
            failedData.put("succCount", 0);
            return Result.failure((ErrorCode)ErrorCode.DATA_EMPTY, failedData);
        }
        ArrayList<ConfigAllInfo> configInfoList4Clone = new ArrayList<ConfigAllInfo>(queryedDataList.size());
        for (ConfigAllInfo ci : queryedDataList) {
            SameNamespaceCloneConfigBean paramBean = configBeansMap.get(ci.getId());
            ConfigAllInfo configAllInfo = new ConfigAllInfo();
            configAllInfo.setTenant(namespaceId);
            configAllInfo.setType(ci.getType());
            configAllInfo.setGroup(paramBean != null && StringUtils.isNotBlank((String)paramBean.getGroup()) ? paramBean.getGroup() : ci.getGroup());
            configAllInfo.setDataId(paramBean != null && StringUtils.isNotBlank((String)paramBean.getDataId()) ? paramBean.getDataId() : ci.getDataId());
            configAllInfo.setContent(ci.getContent());
            if (StringUtils.isNotBlank((String)ci.getAppName())) {
                configAllInfo.setAppName(ci.getAppName());
            }
            configAllInfo.setDesc(ci.getDesc());
            configAllInfo.setEncryptedDataKey(ci.getEncryptedDataKey() == null ? "" : ci.getEncryptedDataKey());
            configInfoList4Clone.add(configAllInfo);
        }
        Timestamp time = TimeUtils.getCurrentTime();
        Map saveResult = this.configInfoPersistService.batchInsertOrUpdate(configInfoList4Clone, srcUser, srcIp, null, policy);
        for (ConfigInfo configInfo : configInfoList4Clone) {
            ConfigChangePublisher.notifyConfigChange((ConfigDataChangeEvent)new ConfigDataChangeEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
            ConfigTraceService.logPersistenceEvent((String)configInfo.getDataId(), (String)configInfo.getGroup(), (String)configInfo.getTenant(), (String)requestIpApp, (long)time.getTime(), (String)InetUtils.getSelfIP(), (String)"persist", (String)"pub", (String)configInfo.getContent());
        }
        return Result.success((Object)saveResult);
    }

    @Override
    public boolean removeBetaConfig(String dataId, String group, String namespaceId, String remoteIp, String requestIpApp, String srcUser) {
        try {
            this.configInfoGrayPersistService.removeConfigInfoGray(dataId, group, namespaceId, "beta", remoteIp, srcUser);
            this.configMigrateService.removeConfigInfoGrayMigrate(dataId, group, namespaceId, "beta", remoteIp, srcUser);
        }
        catch (Throwable e) {
            LOGGER.error("remove beta data error", e);
            return false;
        }
        ConfigTraceService.logPersistenceEvent((String)dataId, (String)group, (String)namespaceId, (String)requestIpApp, (long)System.currentTimeMillis(), (String)remoteIp, (String)"persist-beta", (String)"remove", null);
        if (PropertyUtil.isGrayCompatibleModel()) {
            this.configInfoBetaPersistService.removeConfigInfo4Beta(dataId, group, namespaceId);
        }
        ConfigChangePublisher.notifyConfigChange((ConfigDataChangeEvent)new ConfigDataChangeEvent(dataId, group, namespaceId, "beta", System.currentTimeMillis()));
        return true;
    }

    @Override
    public ConfigGrayInfo queryBetaConfig(String dataId, String group, String namespaceId) throws NacosException {
        ConfigInfoGrayWrapper beta4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, namespaceId, "beta");
        if (Objects.nonNull(beta4Gray)) {
            String encryptedDataKey = beta4Gray.getEncryptedDataKey();
            Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)beta4Gray.getContent());
            beta4Gray.setContent((String)pair.getSecond());
            return ResponseUtil.transferToConfigGrayInfo((ConfigInfoGrayWrapper)beta4Gray);
        }
        return null;
    }

    private Page<ConfigBasicInfo> transferToConfigBasicInfo(Page<ConfigInfo> configInfoPage) {
        Page result = new Page();
        result.setTotalCount(configInfoPage.getTotalCount());
        result.setPagesAvailable(configInfoPage.getPagesAvailable());
        result.setPageNumber(configInfoPage.getPageNumber());
        result.setPageItems(configInfoPage.getPageItems().stream().map(ResponseUtil::transferToConfigBasicInfo).collect(Collectors.toList()));
        return result;
    }
}

