/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl;

import com.alibaba.nacos.console.handler.ServerStateHandler;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.DiskUtils;
import java.io.File;

public abstract class AbstractServerStateHandler
implements ServerStateHandler {
    private static final String ANNOUNCEMENT_FILE = "announcement.conf";
    private static final String GUIDE_FILE = "console-guide.conf";

    @Override
    public String getAnnouncement(String language) {
        String file = ANNOUNCEMENT_FILE.substring(0, ANNOUNCEMENT_FILE.length() - 5) + "_" + language + ".conf";
        if (file.contains("..") || file.contains("/") || file.contains("\\")) {
            throw new IllegalArgumentException("Invalid filename");
        }
        File announcementFile = new File(EnvUtil.getConfPath(), file);
        String announcement = null;
        if (announcementFile.exists() && announcementFile.isFile()) {
            announcement = DiskUtils.readFile((File)announcementFile);
        }
        return announcement;
    }

    @Override
    public String getConsoleUiGuide() {
        File guideFile = new File(EnvUtil.getConfPath(), GUIDE_FILE);
        String guideInformation = null;
        if (guideFile.exists() && guideFile.isFile()) {
            guideInformation = DiskUtils.readFile((File)guideFile);
        }
        return guideInformation;
    }
}

